/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arithmetic;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyElementType;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks.OpenOrClosableBlock;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arguments.ArgumentList;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary.CompoundStringExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary.PrimaryExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeArguments;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class PathExpression
implements GroovyElementTypes {
    private static final TokenSet DOTS = TokenSet.create((IElementType[])new IElementType[]{mSPREAD_DOT, mOPTIONAL_DOT, mMEMBER_POINTER, mDOT});
    private static final TokenSet PATH_ELEMENT_START = TokenSet.create((IElementType[])new IElementType[]{mSPREAD_DOT, mOPTIONAL_DOT, mMEMBER_POINTER, mLBRACK, mLPAREN, mLCURLY, mDOT});

    public static boolean parse(@NotNull PsiBuilder builder, @NotNull GroovyParser parser) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parse"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parse"));
        }
        return PathExpression.parsePathExprQualifierForExprStatement(builder, parser) != Result.WRONG_WAY;
    }

    @NotNull
    public static Result parsePathExprQualifierForExprStatement(@NotNull PsiBuilder builder, @NotNull GroovyParser parser) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parsePathExprQualifierForExprStatement"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parsePathExprQualifierForExprStatement"));
        }
        PsiBuilder.Marker marker = builder.mark();
        IElementType qualifierType = PrimaryExpression.parsePrimaryExpression(builder, parser);
        if (qualifierType != WRONGWAY) {
            Result result = PathExpression.parseAfterQualifier(builder, parser, marker, qualifierType);
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parsePathExprQualifierForExprStatement"));
            }
            return result;
        }
        marker.drop();
        Result result = Result.WRONG_WAY;
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parsePathExprQualifierForExprStatement"));
        }
        return result;
    }

    @NotNull
    private static Result parseAfterQualifier(@NotNull PsiBuilder builder, @NotNull GroovyParser parser, @NotNull PsiBuilder.Marker marker, @NotNull IElementType qualifierType) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterQualifier"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterQualifier"));
        }
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterQualifier"));
        }
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterQualifier"));
        }
        if (PathExpression.isPathElementStart(builder)) {
            if (PathExpression.isLParenthOrLCurlyAfterLiteral(builder, qualifierType)) {
                marker.rollbackTo();
                PsiBuilder.Marker newMarker = builder.mark();
                IElementType newQualifierType = PrimaryExpression.parsePrimaryExpression(builder, parser, true);
                assert (newQualifierType != WRONGWAY);
                Result result = PathExpression.parseAfterReference(builder, parser, newMarker);
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterQualifier"));
                }
                return result;
            }
            Result result = PathExpression.parseAfterReference(builder, parser, marker);
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterQualifier"));
            }
            return result;
        }
        marker.drop();
        if (qualifierType == LITERAL) {
            Result result = Result.LITERAL;
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterQualifier"));
            }
            return result;
        }
        Result result = Result.INVOKED_EXPR;
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterQualifier"));
        }
        return result;
    }

    private static boolean isLParenthOrLCurlyAfterLiteral(@NotNull PsiBuilder builder, @NotNull IElementType qualifierType) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "isLParenthOrLCurlyAfterLiteral"));
        }
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "isLParenthOrLCurlyAfterLiteral"));
        }
        return qualifierType == LITERAL && (PathExpression.checkForLParenth(builder) || PathExpression.checkForLCurly(builder));
    }

    @NotNull
    private static Result pathElementParse(@NotNull PsiBuilder builder, @NotNull PsiBuilder.Marker marker, @NotNull GroovyParser parser, @NotNull Result result) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
        }
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
        }
        if (DOTS.contains(builder.getTokenType()) || ParserUtils.lookAhead(builder, mNLS, mDOT)) {
            if (ParserUtils.lookAhead(builder, mNLS, mDOT)) {
                ParserUtils.getToken(builder, mNLS);
            }
            ParserUtils.getToken(builder, DOTS);
            ParserUtils.getToken(builder, mNLS);
            TypeArguments.parseTypeArguments(builder, true);
            GroovyElementType res = PathExpression.namePartParse(builder, parser);
            if (res != WRONGWAY) {
                PsiBuilder.Marker newMarker = marker.precede();
                marker.done((IElementType)res);
                Result result2 = PathExpression.parseAfterReference(builder, parser, newMarker);
                if (result2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
                }
                return result2;
            }
            builder.error(GroovyBundle.message("path.selector.expected", new Object[0]));
            marker.drop();
            Result result3 = result;
            if (result3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
            }
            return result3;
        }
        if (PathExpression.checkForLParenth(builder)) {
            PrimaryExpression.methodCallArgsParse(builder, parser);
            Result result4 = PathExpression.parseAfterArguments(builder, marker, parser);
            if (result4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
            }
            return result4;
        }
        if (PathExpression.checkForLCurly(builder)) {
            ParserUtils.getToken(builder, mNLS);
            PathExpression.appendedBlockParse(builder, parser);
            Result result5 = PathExpression.parseAfterArguments(builder, marker, parser);
            if (result5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
            }
            return result5;
        }
        if (PathExpression.checkForArrayAccess(builder)) {
            PathExpression.indexPropertyArgsParse(builder, parser);
            PsiBuilder.Marker newMarker = marker.precede();
            marker.done((IElementType)PATH_INDEX_PROPERTY);
            Result result6 = PathExpression.parseAfterReference(builder, parser, newMarker);
            if (result6 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
            }
            return result6;
        }
        marker.drop();
        Result result7 = result;
        if (result7 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "pathElementParse"));
        }
        return result7;
    }

    @NotNull
    private static Result parseAfterReference(@NotNull PsiBuilder builder, @NotNull GroovyParser parser, @NotNull PsiBuilder.Marker newMarker) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterReference"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterReference"));
        }
        if (newMarker == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterReference"));
        }
        if (PathExpression.checkForLCurly(builder)) {
            PsiBuilder.Marker argsMarker = builder.mark();
            argsMarker.done((IElementType)ARGUMENTS);
            ParserUtils.getToken(builder, mNLS);
            Result result = PathExpression.pathElementParse(builder, newMarker, parser, Result.METHOD_CALL);
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterReference"));
            }
            return result;
        }
        Result result = PathExpression.pathElementParse(builder, newMarker, parser, Result.INVOKED_EXPR);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterReference"));
        }
        return result;
    }

    @NotNull
    private static Result parseAfterArguments(@NotNull PsiBuilder builder, @NotNull PsiBuilder.Marker marker, @NotNull GroovyParser parser) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterArguments"));
        }
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterArguments"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterArguments"));
        }
        if (PathExpression.checkForLCurly(builder)) {
            ParserUtils.getToken(builder, mNLS);
            Result result = PathExpression.pathElementParse(builder, marker, parser, Result.METHOD_CALL);
            if (result == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterArguments"));
            }
            return result;
        }
        PsiBuilder.Marker newMarker = marker.precede();
        marker.done((IElementType)PATH_METHOD_CALL);
        Result result = PathExpression.pathElementParse(builder, newMarker, parser, Result.METHOD_CALL);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "parseAfterArguments"));
        }
        return result;
    }

    private static boolean checkForLCurly(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "checkForLCurly"));
        }
        return ParserUtils.lookAhead(builder, mLCURLY) || ParserUtils.lookAhead(builder, mNLS, mLCURLY);
    }

    private static boolean checkForLParenth(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "checkForLParenth"));
        }
        return builder.getTokenType() == mLPAREN;
    }

    public static boolean checkForArrayAccess(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "checkForArrayAccess"));
        }
        return builder.getTokenType() == mLBRACK && !ParserUtils.lookAhead(builder, mLBRACK, mCOLON) && !ParserUtils.lookAhead(builder, mLBRACK, mNLS, mCOLON);
    }

    @NotNull
    public static GroovyElementType namePartParse(@NotNull PsiBuilder builder, @NotNull GroovyParser parser) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
        }
        ParserUtils.getToken(builder, mAT);
        if (ParserUtils.getToken(builder, mIDENT) || ParserUtils.getToken(builder, mSTRING_LITERAL) || ParserUtils.getToken(builder, mGSTRING_LITERAL)) {
            GroovyElementType groovyElementType = REFERENCE_EXPRESSION;
            if (groovyElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
            }
            return groovyElementType;
        }
        IElementType tokenType = builder.getTokenType();
        if (tokenType == mGSTRING_BEGIN) {
            boolean result = CompoundStringExpression.parse(builder, parser, true, mGSTRING_BEGIN, mGSTRING_CONTENT, mGSTRING_END, null, GSTRING, GroovyBundle.message("string.end.expected", new Object[0]));
            GroovyElementType groovyElementType = result ? PATH_PROPERTY_REFERENCE : REFERENCE_EXPRESSION;
            if (groovyElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
            }
            return groovyElementType;
        }
        if (tokenType == mREGEX_BEGIN) {
            boolean result = CompoundStringExpression.parse(builder, parser, true, mREGEX_BEGIN, mREGEX_CONTENT, mREGEX_END, mREGEX_LITERAL, REGEX, GroovyBundle.message("regex.end.expected", new Object[0]));
            GroovyElementType groovyElementType = result ? PATH_PROPERTY_REFERENCE : REFERENCE_EXPRESSION;
            if (groovyElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
            }
            return groovyElementType;
        }
        if (tokenType == mDOLLAR_SLASH_REGEX_BEGIN) {
            boolean result = CompoundStringExpression.parse(builder, parser, true, mDOLLAR_SLASH_REGEX_BEGIN, mDOLLAR_SLASH_REGEX_CONTENT, mDOLLAR_SLASH_REGEX_END, mDOLLAR_SLASH_REGEX_LITERAL, REGEX, GroovyBundle.message("dollar.slash.end.expected", new Object[0]));
            GroovyElementType groovyElementType = result ? PATH_PROPERTY_REFERENCE : REFERENCE_EXPRESSION;
            if (groovyElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
            }
            return groovyElementType;
        }
        if (tokenType == mLCURLY) {
            OpenOrClosableBlock.parseOpenBlock(builder, parser);
            GroovyElementType groovyElementType = PATH_PROPERTY_REFERENCE;
            if (groovyElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
            }
            return groovyElementType;
        }
        if (tokenType == mLPAREN) {
            PrimaryExpression.parenthesizedExprParse(builder, parser);
            GroovyElementType groovyElementType = PATH_PROPERTY_REFERENCE;
            if (groovyElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
            }
            return groovyElementType;
        }
        if (TokenSets.KEYWORDS.contains(builder.getTokenType())) {
            builder.advanceLexer();
            GroovyElementType groovyElementType = REFERENCE_EXPRESSION;
            if (groovyElementType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
            }
            return groovyElementType;
        }
        GroovyElementType groovyElementType = WRONGWAY;
        if (groovyElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "namePartParse"));
        }
        return groovyElementType;
    }

    @NotNull
    public static GroovyElementType indexPropertyArgsParse(@NotNull PsiBuilder builder, @NotNull GroovyParser parser) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "indexPropertyArgsParse"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "indexPropertyArgsParse"));
        }
        assert (builder.getTokenType() == mLBRACK);
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.getToken(builder, mLBRACK);
        ParserUtils.getToken(builder, mNLS);
        ArgumentList.parseArgumentList(builder, mRBRACK, parser);
        ParserUtils.getToken(builder, mNLS);
        ParserUtils.getToken(builder, mRBRACK, GroovyBundle.message("rbrack.expected", new Object[0]));
        marker.done((IElementType)ARGUMENTS);
        GroovyElementType groovyElementType = PATH_INDEX_PROPERTY;
        if (groovyElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "indexPropertyArgsParse"));
        }
        return groovyElementType;
    }

    @NotNull
    private static IElementType appendedBlockParse(@NotNull PsiBuilder builder, @NotNull GroovyParser parser) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "appendedBlockParse"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "appendedBlockParse"));
        }
        IElementType iElementType = OpenOrClosableBlock.parseClosableBlock(builder, parser);
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "appendedBlockParse"));
        }
        return iElementType;
    }

    private static boolean isPathElementStart(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/expressions/arithmetic/PathExpression", "isPathElementStart"));
        }
        return PATH_ELEMENT_START.contains(builder.getTokenType()) || ParserUtils.lookAhead(builder, mNLS, mDOT) || ParserUtils.lookAhead(builder, mNLS, mLCURLY);
    }

    public static enum Result {
        INVOKED_EXPR,
        METHOD_CALL,
        WRONG_WAY,
        LITERAL;

    }
}

