/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.arguments;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.AssignmentExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.expressions.primary.PrimaryExpression;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class ArgumentList
implements GroovyElementTypes {
    private static final TokenSet CONTROL_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{kASSERT, kBREAK, kCASE, kCLASS, kCONTINUE, kDEF, kDEFAULT, kDO, kELSE, kENUM, kFINAL, kFOR, kFINALLY, kIF, kIMPLEMENTS, kIMPORT, kINTERFACE, kNATIVE, kPACKAGE, kPRIVATE, kPROTECTED, kPUBLIC, kRETURN, kSTATIC, kSTRICTFP, kSWITCH, kSYNCHRONIZED, kTHROW, kTHROWS, kTRANSIENT, kTRY, kVOLATILE, kWHILE});

    public static void parseArgumentList(PsiBuilder builder, IElementType closingBrace, GroovyParser parser) {
        boolean hasFirstArg = ArgumentList.argumentParse(builder, parser);
        if (!hasFirstArg) {
            if (!closingBrace.equals(builder.getTokenType())) {
                builder.error(GroovyBundle.message("expression.expected", new Object[0]));
            }
            if (mRCURLY.equals(builder.getTokenType())) {
                return;
            }
            if (!mCOMMA.equals(builder.getTokenType()) && !closingBrace.equals(builder.getTokenType())) {
                builder.advanceLexer();
            }
        }
        ParserUtils.getToken(builder, mNLS);
        boolean hasErrors = false;
        while (!builder.eof() && !closingBrace.equals(builder.getTokenType())) {
            if (!ParserUtils.getToken(builder, mCOMMA) && hasFirstArg) {
                builder.error("',' or '" + closingBrace + "' expected");
                hasErrors = true;
            }
            ParserUtils.getToken(builder, mNLS);
            if (hasErrors && CONTROL_KEYWORDS.contains(builder.getTokenType())) {
                return;
            }
            if (!ArgumentList.argumentParse(builder, parser)) {
                if (!closingBrace.equals(builder.getTokenType())) {
                    builder.error(GroovyBundle.message("expression.expected", new Object[0]));
                    hasErrors = true;
                }
                if (mRCURLY.equals(builder.getTokenType())) {
                    return;
                }
                if (!mCOMMA.equals(builder.getTokenType()) && !closingBrace.equals(builder.getTokenType())) {
                    builder.advanceLexer();
                }
            }
            ParserUtils.getToken(builder, mNLS);
        }
        ParserUtils.getToken(builder, mNLS);
    }

    private static boolean argumentParse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker argMarker = builder.mark();
        if (ArgumentList.argumentLabelStartCheck(builder, parser)) {
            ParserUtils.getToken(builder, mCOLON, GroovyBundle.message("colon.expected", new Object[0]));
            if (!AssignmentExpression.parse(builder, parser)) {
                builder.error(GroovyBundle.message("expression.expected", new Object[0]));
            }
            argMarker.done((IElementType)NAMED_ARGUMENT);
            return true;
        }
        if (ParserUtils.getToken(builder, mSTAR)) {
            if (AssignmentExpression.parse(builder, parser)) {
                argMarker.done((IElementType)SPREAD_ARGUMENT);
            } else {
                builder.error(GroovyBundle.message("colon.expected", new Object[0]));
                argMarker.done((IElementType)NAMED_ARGUMENT);
            }
            return true;
        }
        argMarker.drop();
        return AssignmentExpression.parse(builder, parser);
    }

    public static boolean argumentLabelStartCheck(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        if (ParserUtils.lookAhead(builder, mSTAR, mCOLON)) {
            builder.advanceLexer();
            marker.done((IElementType)ARGUMENT_LABEL);
            return true;
        }
        IElementType type = builder.getTokenType();
        if (ParserUtils.lookAhead(builder, mIDENT, mCOLON) || TokenSets.KEYWORDS.contains(type) || mSTRING_LITERAL.equals(type) || mGSTRING_LITERAL.equals(type)) {
            builder.advanceLexer();
            if (mCOLON.equals(builder.getTokenType())) {
                marker.done((IElementType)ARGUMENT_LABEL);
                return true;
            }
            marker.rollbackTo();
            return false;
        }
        if (mGSTRING_BEGIN.equals(type) || mREGEX_BEGIN.equals(type) || mDOLLAR_SLASH_REGEX_BEGIN.equals(type) || TokenSets.NUMBERS.contains(type) || mLBRACK.equals(type) || mLPAREN.equals(type) || mLCURLY.equals(type)) {
            PrimaryExpression.parsePrimaryExpression(builder, parser);
            if (mCOLON.equals(builder.getTokenType())) {
                marker.done((IElementType)ARGUMENT_LABEL);
                return true;
            }
            marker.rollbackTo();
            return false;
        }
        marker.drop();
        return false;
    }
}

