/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.parameters.ParameterDeclaration;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.blocks.OpenOrClosableBlock;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class TryCatchStatement
implements GroovyElementTypes {
    public static boolean parse(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker marker = builder.mark();
        ParserUtils.getToken(builder, kTRY);
        PsiBuilder.Marker warn = builder.mark();
        ParserUtils.getToken(builder, mNLS);
        if (!OpenOrClosableBlock.parseOpenBlock(builder, parser)) {
            warn.rollbackTo();
            builder.error(GroovyBundle.message("lcurly.expected", new Object[0]));
            marker.drop();
            return true;
        }
        warn.drop();
        ParserUtils.getToken(builder, mNLS);
        if (builder.getTokenType() != kCATCH && builder.getTokenType() != kFINALLY) {
            builder.error(GroovyBundle.message("catch.or.finally.expected", new Object[0]));
            marker.done((IElementType)TRY_BLOCK_STATEMENT);
            return true;
        }
        if (kCATCH.equals(builder.getTokenType())) {
            TryCatchStatement.parseHandlers(builder, parser);
        }
        if (kFINALLY.equals(builder.getTokenType()) || ParserUtils.lookAhead(builder, mNLS, kFINALLY)) {
            TryCatchStatement.parseFinally(builder, parser);
        }
        marker.done((IElementType)TRY_BLOCK_STATEMENT);
        return true;
    }

    private static void parseFinally(PsiBuilder builder, GroovyParser parser) {
        ParserUtils.getToken(builder, mNLS);
        PsiBuilder.Marker finallyMarker = builder.mark();
        ParserUtils.getToken(builder, kFINALLY);
        ParserUtils.getToken(builder, mNLS);
        PsiBuilder.Marker warn = builder.mark();
        if (mLCURLY.equals(builder.getTokenType()) && OpenOrClosableBlock.parseOpenBlock(builder, parser)) {
            warn.drop();
        } else {
            warn.rollbackTo();
            builder.error(GroovyBundle.message("lcurly.expected", new Object[0]));
        }
        finallyMarker.done((IElementType)FINALLY_CLAUSE);
    }

    private static void parseHandlers(PsiBuilder builder, GroovyParser parser) {
        PsiBuilder.Marker catchMarker = builder.mark();
        ParserUtils.getToken(builder, kCATCH);
        if (!ParserUtils.getToken(builder, mLPAREN, GroovyBundle.message("lparen.expected", new Object[0]))) {
            catchMarker.done((IElementType)CATCH_CLAUSE);
            return;
        }
        if (!ParameterDeclaration.parseCatchParameter(builder, parser)) {
            builder.error(GroovyBundle.message("param.expected", new Object[0]));
        }
        if (!ParserUtils.getToken(builder, mRPAREN, GroovyBundle.message("rparen.expected", new Object[0]))) {
            catchMarker.done((IElementType)CATCH_CLAUSE);
            return;
        }
        PsiBuilder.Marker warn = builder.mark();
        ParserUtils.getToken(builder, mNLS);
        if (!mLCURLY.equals(builder.getTokenType()) || !OpenOrClosableBlock.parseOpenBlock(builder, parser)) {
            warn.rollbackTo();
            builder.error(GroovyBundle.message("lcurly.expected", new Object[0]));
        } else {
            warn.drop();
        }
        catchMarker.done((IElementType)CATCH_CLAUSE);
        if (builder.getTokenType() == kCATCH || ParserUtils.lookAhead(builder, mNLS, kCATCH)) {
            ParserUtils.getToken(builder, mNLS);
            TryCatchStatement.parseHandlers(builder, parser);
        }
    }
}

