/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovySmartEnterProcessor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSynchronizedStatement;

public class GrSynchronizedFixer
extends SmartEnterProcessorWithFixers.Fixer<GroovySmartEnterProcessor> {
    public void apply(@NotNull Editor editor, @NotNull GroovySmartEnterProcessor processor, @NotNull PsiElement psiElement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/completion/smartEnter/fixers/GrSynchronizedFixer", "apply"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/completion/smartEnter/fixers/GrSynchronizedFixer", "apply"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/completion/smartEnter/fixers/GrSynchronizedFixer", "apply"));
        }
        GrSynchronizedStatement synchronizedStatement = (GrSynchronizedStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, GrSynchronizedStatement.class);
        if (synchronizedStatement == null || synchronizedStatement.getBody() != null) {
            return;
        }
        if (!PsiTreeUtil.isAncestor((PsiElement)synchronizedStatement.getMonitor(), (PsiElement)psiElement, (boolean)false)) {
            return;
        }
        Document doc = editor.getDocument();
        PsiElement eltToInsertAfter = synchronizedStatement.getRParenth();
        String text = "{\n}";
        if (eltToInsertAfter == null) {
            eltToInsertAfter = synchronizedStatement.getMonitor();
            text = "){\n}";
        }
        doc.insertString(eltToInsertAfter.getTextRange().getEndOffset(), (CharSequence)text);
    }
}

