/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion.smartEnter.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.completion.smartEnter.GroovySmartEnterProcessor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;

public class GrForBodyFixer
extends SmartEnterProcessorWithFixers.Fixer<GroovySmartEnterProcessor> {
    public void apply(@NotNull Editor editor, @NotNull GroovySmartEnterProcessor processor, @NotNull PsiElement psiElement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/completion/smartEnter/fixers/GrForBodyFixer", "apply"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/completion/smartEnter/fixers/GrForBodyFixer", "apply"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/completion/smartEnter/fixers/GrForBodyFixer", "apply"));
        }
        GrForStatement forStatement = (GrForStatement)PsiTreeUtil.getParentOfType((PsiElement)psiElement, GrForStatement.class);
        if (forStatement == null) {
            return;
        }
        Document doc = editor.getDocument();
        GrStatement body = forStatement.getBody();
        if (body instanceof GrBlockStatement) {
            return;
        }
        if (body != null && GrForBodyFixer.startLine(doc, body) == GrForBodyFixer.startLine(doc, forStatement)) {
            return;
        }
        PsiElement eltToInsertAfter = forStatement.getRParenth();
        String text = "{}";
        if (eltToInsertAfter == null) {
            eltToInsertAfter = forStatement;
            text = "){}";
        }
        doc.insertString(eltToInsertAfter.getTextRange().getEndOffset(), (CharSequence)text);
    }

    static int startLine(Document doc, PsiElement psiElement) {
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

