/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.AllClassesGetter;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.originInfo.OriginInfoProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.formatter.GeeseUtil;
import org.jetbrains.plugins.groovy.lang.completion.GroovyClassNameInsertHandler;
import org.jetbrains.plugins.groovy.lang.completion.GroovyInsertHandler;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrControlFlowOwner;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClassTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrAnnotationCollector;
import org.jetbrains.plugins.groovy.lang.psi.util.GdkMethodUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class GroovyCompletionUtil {
    private static final TokenSet SEPARATORS = TokenSet.create((IElementType[])new IElementType[]{GroovyTokenTypes.mNLS, GroovyTokenTypes.mSEMI});
    public static final Set<String> OPERATOR_METHOD_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"plus", "minus", "multiply", "power", "div", "mod", "or", "and", "xor", "next", "previous", "getAt", "putAt", "leftShift", "rightShift", "isCase", "bitwiseNegate", "negative", "positive", "call"});

    private GroovyCompletionUtil() {
    }

    public static boolean endsWithExpression(PsiElement statement) {
        while (statement != null && !(statement instanceof GrExpression)) {
            if (!((statement = statement.getLastChild()) instanceof PsiErrorElement)) continue;
            statement = GroovyCompletionUtil.nearestLeftSibling(statement);
        }
        return statement != null;
    }

    @Nullable
    public static PsiElement nearestLeftSibling(PsiElement elem) {
        for (elem = elem.getPrevSibling(); elem != null && (elem instanceof PsiWhiteSpace || elem instanceof PsiComment || GroovyTokenTypes.mNLS.equals(elem.getNode().getElementType())); elem = elem.getPrevSibling()) {
        }
        return elem;
    }

    @Nullable
    public static PsiElement nearestLeftLeaf(PsiElement elem) {
        elem = PsiTreeUtil.prevLeaf((PsiElement)elem);
        while (elem != null && (elem instanceof PsiWhiteSpace || elem instanceof PsiComment || GroovyTokenTypes.mNLS.equals(elem.getNode().getElementType()))) {
            elem = PsiTreeUtil.prevLeaf((PsiElement)elem);
        }
        return elem;
    }

    public static boolean isNewStatement(PsiElement element, boolean canBeAfterBrace) {
        PsiElement previousLeaf = GroovyCompletionUtil.getLeafByOffset(element.getTextRange().getStartOffset() - 1, element);
        if ((previousLeaf = PsiImplUtil.realPrevious(previousLeaf)) != null) {
            if (canBeAfterBrace && GroovyTokenTypes.mLCURLY.equals(previousLeaf.getNode().getElementType())) {
                return true;
            }
            if (GroovyTokenTypes.mCOLON.equals(previousLeaf.getNode().getElementType()) && previousLeaf.getParent() instanceof GrLabeledStatement) {
                return true;
            }
        }
        return previousLeaf == null || SEPARATORS.contains(previousLeaf.getNode().getElementType());
    }

    @Nullable
    public static PsiElement getLeafByOffset(int offset, PsiElement element) {
        if (offset < 0) {
            return null;
        }
        PsiFile candidate = element.getContainingFile();
        while (candidate.getNode().getFirstChildNode() != null) {
            candidate = candidate.findElementAt(offset);
        }
        return candidate;
    }

    public static boolean isFirstElementAfterPossibleModifiersInVariableDeclaration(PsiElement element, boolean acceptParameter) {
        if (element.getParent() instanceof GrTypeDefinitionBody && !(element instanceof PsiComment)) {
            String text = element.getContainingFile().getText();
            int i = CharArrayUtil.shiftBackward((CharSequence)text, (int)(element.getTextRange().getStartOffset() - 1), (String)" \t");
            return i >= 0 && (text.charAt(i) == '\n' || text.charAt(i) == '{');
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof GrVariable)) {
            return false;
        }
        if (acceptParameter && parent instanceof GrParameter) {
            return ((GrParameter)parent).getTypeElementGroovy() == null;
        }
        PsiElement pparent = parent.getParent();
        if (!(pparent instanceof GrVariableDeclaration)) {
            return false;
        }
        if (((GrVariableDeclaration)pparent).isTuple()) {
            return false;
        }
        GrVariableDeclaration variableDeclaration = (GrVariableDeclaration)pparent;
        if (variableDeclaration.getTypeElementGroovy() != null) {
            return false;
        }
        return variableDeclaration.getVariables()[0] == parent;
    }

    public static boolean asSimpleVariable(PsiElement context) {
        return GroovyCompletionUtil.isInTypeDefinitionBody(context) && GroovyCompletionUtil.isNewStatement(context, true);
    }

    public static boolean isInTypeDefinitionBody(PsiElement context) {
        return context.getParent() instanceof GrCodeReferenceElement && context.getParent().getParent() instanceof GrClassTypeElement && context.getParent().getParent().getParent() instanceof GrTypeDefinitionBody || context.getParent() instanceof GrTypeDefinitionBody;
    }

    public static boolean asVariableInBlock(PsiElement context) {
        if (context.getParent() instanceof GrReferenceExpression) {
            PsiElement parent = context.getParent().getParent();
            while (parent instanceof GrStatement) {
                parent = parent.getParent();
            }
            if ((parent instanceof GrControlFlowOwner || parent instanceof GrCaseSection) && GroovyCompletionUtil.isNewStatement(context, true)) {
                return true;
            }
        }
        return context.getParent() instanceof GrTypeDefinitionBody && GroovyCompletionUtil.isNewStatement(context, true);
    }

    public static boolean asTypedMethod(PsiElement context) {
        return context.getParent() instanceof GrReferenceElement && context.getParent().getParent() instanceof GrTypeElement && context.getParent().getParent().getParent() instanceof GrMethod && context.getParent().getParent().getParent().getParent() instanceof GrTypeDefinitionBody && context.getTextRange().getStartOffset() == context.getParent().getParent().getParent().getParent().getTextRange().getStartOffset();
    }

    public static List<LookupElement> getCompletionVariants(GroovyResolveResult[] candidates, boolean afterNew, PrefixMatcher matcher, PsiElement position) {
        ArrayList result = ContainerUtil.newArrayList();
        for (GroovyResolveResult candidate : candidates) {
            result.addAll(GroovyCompletionUtil.createLookupElements(candidate, afterNew, matcher, position));
            ProgressManager.checkCanceled();
        }
        return result;
    }

    public static List<LookupElement> getCompletionVariants(List<GroovyResolveResult> candidates, boolean afterNew, PrefixMatcher matcher, PsiElement position) {
        ArrayList result = ContainerUtil.newArrayList();
        for (GroovyResolveResult candidate : candidates) {
            result.addAll(GroovyCompletionUtil.createLookupElements(candidate, afterNew, matcher, position));
            ProgressManager.checkCanceled();
        }
        return result;
    }

    public static List<? extends LookupElement> createLookupElements(@NotNull GroovyResolveResult candidate, boolean afterNew, @NotNull PrefixMatcher matcher, @Nullable PsiElement position) {
        String name;
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionUtil", "createLookupElements"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionUtil", "createLookupElements"));
        }
        PsiElement element = candidate.getElement();
        PsiElement context = candidate.getCurrentFileResolveContext();
        if (context instanceof GrImportStatement && element != null) {
            if (element instanceof PsiPackage) {
                return Collections.emptyList();
            }
            String importedName = ((GrImportStatement)context).getImportedName();
            if (importedName != null) {
                if (!(matcher.prefixMatches(importedName) || element instanceof PsiMethod && GroovyCompletionUtil.getterMatches(matcher, (PsiMethod)element, importedName) || element instanceof PsiMethod && GroovyCompletionUtil.setterMatches(matcher, (PsiMethod)element, importedName))) {
                    return Collections.emptyList();
                }
                GrCodeReferenceElement importReference = ((GrImportStatement)context).getImportReference();
                if (importReference != null) {
                    boolean alias = ((GrImportStatement)context).isAliasedImport();
                    for (GroovyResolveResult r : importReference.multiResolve(false)) {
                        PsiElement resolved = r.getElement();
                        if (context.getManager().areElementsEquivalent(resolved, element) && (alias || !(element instanceof PsiClass))) {
                            return GroovyCompletionUtil.generateLookupForImportedElement(candidate, importedName, alias);
                        }
                        if (!(resolved instanceof PsiField) || !(element instanceof PsiMethod) || !GroovyPropertyUtils.isAccessorFor((PsiMethod)element, (PsiField)resolved)) continue;
                        return GroovyCompletionUtil.generateLookupForImportedElement(candidate, GroovyPropertyUtils.getAccessorPrefix((PsiMethod)element) + GroovyPropertyUtils.capitalize(importedName), alias);
                    }
                }
            }
        }
        String string = name = element instanceof PsiNamedElement ? ((PsiNamedElement)element).getName() : element.getText();
        if (name == null || !matcher.prefixMatches(name)) {
            return Collections.emptyList();
        }
        if (element instanceof PsiClass) {
            return JavaClassNameCompletionContributor.createClassLookupItems((PsiClass)((PsiClass)element), (boolean)afterNew, (InsertHandler)new GroovyClassNameInsertHandler(), (Condition)Condition.TRUE);
        }
        LookupElementBuilder builder = LookupElementBuilder.create((Object)(element instanceof PsiPackage ? element : candidate), (String)name);
        return Arrays.asList(GroovyCompletionUtil.setupLookupBuilder(element, candidate.getSubstitutor(), builder, position));
    }

    private static boolean setterMatches(PrefixMatcher matcher, PsiMethod element, String importedName) {
        return GroovyPropertyUtils.isSimplePropertySetter(element) && matcher.prefixMatches(GroovyPropertyUtils.getSetterName(importedName));
    }

    private static boolean getterMatches(PrefixMatcher matcher, PsiMethod element, String importedName) {
        return GroovyPropertyUtils.isSimplePropertyGetter(element) && (matcher.prefixMatches(GroovyPropertyUtils.getGetterNameNonBoolean(importedName)) || element.getReturnType() == PsiType.BOOLEAN && matcher.prefixMatches(GroovyPropertyUtils.getGetterNameBoolean(importedName)));
    }

    public static LookupElement createClassLookupItem(PsiClass psiClass) {
        assert (psiClass.isValid());
        return AllClassesGetter.createLookupItem((PsiClass)psiClass, (InsertHandler)new GroovyClassNameInsertHandler());
    }

    private static List<? extends LookupElement> generateLookupForImportedElement(GroovyResolveResult resolveResult, String importedName, boolean alias) {
        PsiElement element = resolveResult.getElement();
        assert (element != null);
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        LookupElementBuilder builder = LookupElementBuilder.create((Object)resolveResult, (String)importedName).withPresentableText(importedName);
        return Arrays.asList(GroovyCompletionUtil.setupLookupBuilder(element, substitutor, builder, null));
    }

    public static LookupElement createLookupElement(PsiNamedElement o) {
        return GroovyCompletionUtil.setupLookupBuilder((PsiElement)o, PsiSubstitutor.EMPTY, LookupElementBuilder.create((Object)o, (String)o.getName()), null);
    }

    private static LookupElementBuilder setupLookupBuilder(PsiElement element, PsiSubstitutor substitutor, LookupElementBuilder builder, @Nullable PsiElement position) {
        builder = builder.withIcon(element.getIcon(3)).withInsertHandler((InsertHandler)GroovyInsertHandler.INSTANCE);
        builder = GroovyCompletionUtil.setTailText(element, builder, substitutor);
        builder = GroovyCompletionUtil.setTypeText(element, builder, substitutor, position);
        return builder;
    }

    private static LookupElementBuilder setTailText(PsiElement element, LookupElementBuilder builder, PsiSubstitutor substitutor) {
        if (element instanceof PsiMethod) {
            PsiClass aClass = ((PsiMethod)element).getContainingClass();
            if (aClass != null && aClass.isAnnotationType()) {
                return builder;
            }
            builder = builder.withTailText(PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)substitutor, (int)256, (int)3));
        } else if (element instanceof PsiClass) {
            String tailText = GroovyCompletionUtil.getPackageText((PsiClass)element);
            PsiClass psiClass = (PsiClass)element;
            if ((substitutor == null || substitutor.getSubstitutionMap().size() == 0) && psiClass.getTypeParameters().length > 0) {
                tailText = "<" + StringUtil.join((Object[])psiClass.getTypeParameters(), (Function)new Function<PsiTypeParameter, String>(){

                    public String fun(PsiTypeParameter psiTypeParameter) {
                        return psiTypeParameter.getName();
                    }
                }, (String)("," + (GroovyCompletionUtil.showSpaceAfterComma(psiClass) ? " " : ""))) + ">" + tailText;
            }
            builder = builder.withTailText(tailText, true);
        }
        String originInfo = OriginInfoProvider.getOriginInfo((PsiElement)element);
        if (originInfo != null) {
            builder = builder.appendTailText(" " + originInfo, true);
        }
        return builder;
    }

    private static String getPackageText(PsiClass psiClass) {
        String packageName = PsiFormatUtil.getPackageDisplayName((PsiClass)psiClass);
        return " (" + packageName + ")";
    }

    private static boolean showSpaceAfterComma(PsiClass element) {
        return CodeStyleSettingsManager.getSettings((Project)element.getProject()).SPACE_AFTER_COMMA;
    }

    private static LookupElementBuilder setTypeText(PsiElement element, LookupElementBuilder builder, PsiSubstitutor substitutor, @Nullable PsiElement position) {
        PsiType type = null;
        if (element instanceof GrVariable) {
            type = position != null && GroovyRefactoringUtil.isLocalVariable(element) ? TypeInferenceHelper.getInferredType(position, ((GrVariable)element).getName()) : ((GrVariable)element).getTypeGroovy();
        } else if (element instanceof PsiVariable) {
            type = ((PsiVariable)element).getType();
        } else if (element instanceof PsiMethod) {
            type = substitutor.substitute(((PsiMethod)element).getReturnType());
        }
        return type != null ? builder.withTypeText(type.getPresentableText()) : builder;
    }

    public static boolean hasConstructorParameters(@NotNull PsiClass clazz, @NotNull PsiElement place) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionUtil", "hasConstructorParameters"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/lang/completion/GroovyCompletionUtil", "hasConstructorParameters"));
        }
        GroovyResolveResult[] constructors = ResolveUtil.getAllClassConstructors(clazz, PsiSubstitutor.EMPTY, null, place);
        boolean hasSetters = ContainerUtil.find((Object[])clazz.getAllMethods(), (Condition)new Condition<PsiMethod>(){

            public boolean value(PsiMethod method) {
                return GroovyPropertyUtils.isSimplePropertySetter(method);
            }
        }) != null;
        boolean hasParameters = false;
        boolean hasAccessibleConstructors = false;
        for (GroovyResolveResult result : constructors) {
            PsiElement element = result.getElement();
            if (!(element instanceof PsiMethod)) continue;
            if (((PsiMethod)element).getParameterList().getParametersCount() > 0) {
                hasParameters = true;
            }
            if (result.isAccessible()) {
                hasAccessibleConstructors = true;
            }
            if (!hasAccessibleConstructors || !hasParameters) continue;
            return true;
        }
        return !hasAccessibleConstructors && (hasParameters || hasSetters);
    }

    public static void addImportForItem(PsiFile file, int startOffset, LookupItem item) throws IncorrectOperationException {
        PsiClass refClass;
        PsiType type;
        PsiDocumentManager.getInstance((Project)file.getProject()).commitAllDocuments();
        Object o = item.getObject();
        if (o instanceof PsiClass) {
            PsiClass aClass = (PsiClass)o;
            if (aClass.getQualifiedName() == null) {
                return;
            }
            String lookupString = item.getLookupString();
            int length = lookupString.length();
            int i = lookupString.indexOf(60);
            if (i >= 0) {
                length = i;
            }
            int newOffset = GroovyCompletionUtil.addImportForClass(file, startOffset, startOffset + length, aClass);
            GroovyCompletionUtil.shortenReference(file, newOffset);
        } else if (o instanceof PsiType && (type = ((PsiType)o).getDeepComponentType()) instanceof PsiClassType && (refClass = ((PsiClassType)type).resolve()) != null) {
            int length = refClass.getName().length();
            GroovyCompletionUtil.addImportForClass(file, startOffset, startOffset + length, refClass);
        }
    }

    public static int addImportForClass(PsiFile file, int startOffset, int endOffset, PsiClass aClass) throws IncorrectOperationException {
        PsiElement resolved;
        PsiManager manager = file.getManager();
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        int newStartOffset = startOffset;
        PsiReference reference = file.findReferenceAt(endOffset - 1);
        if (reference != null && (resolved = reference.resolve()) instanceof PsiClass && (((PsiClass)resolved).getQualifiedName() == null || manager.areElementsEquivalent((PsiElement)aClass, resolved))) {
            return newStartOffset;
        }
        String name = aClass.getName();
        document.replaceString(startOffset, endOffset, (CharSequence)name);
        RangeMarker toDelete = JavaCompletionUtil.insertTemporary((int)endOffset, (Document)document, (String)" ");
        PsiDocumentManager.getInstance((Project)manager.getProject()).commitAllDocuments();
        PsiReference ref = file.findReferenceAt(startOffset);
        if (ref instanceof GrReferenceElement && aClass.isValid()) {
            PsiElement newElement = ref.bindToElement((PsiElement)aClass);
            RangeMarker marker = document.createRangeMarker(newElement.getTextRange());
            CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)newElement);
            newStartOffset = marker.getStartOffset();
        }
        if (toDelete.isValid()) {
            document.deleteString(toDelete.getStartOffset(), toDelete.getEndOffset());
        }
        return newStartOffset;
    }

    public static void shortenReference(PsiFile file, int offset) throws IncorrectOperationException {
        Project project = file.getProject();
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        Document document = manager.getDocument(file);
        assert (document != null);
        manager.commitDocument(document);
        PsiReference ref = file.findReferenceAt(offset);
        if (ref instanceof GrCodeReferenceElement) {
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)((GroovyPsiElement)ref));
        }
    }

    public static int addRParenth(Editor editor, int oldTail, boolean space_within_cast_parentheses) {
        int offset = -1;
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(oldTail);
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (TokenSets.WHITE_SPACES_OR_COMMENTS.contains(tokenType)) {
                iterator.advance();
                continue;
            }
            if (tokenType != GroovyTokenTypes.mRPAREN) break;
            offset = iterator.getEnd();
            break;
        }
        if (offset != -1) {
            return offset;
        }
        offset = oldTail;
        if (space_within_cast_parentheses) {
            offset = TailType.insertChar((Editor)editor, (int)oldTail, (char)' ');
        }
        return TailType.insertChar((Editor)editor, (int)offset, (char)')');
    }

    public static boolean skipDefGroovyMethod(GrGdkMethod gdkMethod, PsiSubstitutor substitutor, @Nullable PsiType type) {
        PsiType substituted;
        if (type == null) {
            return false;
        }
        String name = gdkMethod.getStaticMethod().getName();
        PsiType baseType = gdkMethod.getStaticMethod().getParameterList().getParameters()[0].getType();
        if (!TypeConversionUtil.erasure((PsiType)baseType).equalsToText("java.lang.Object")) {
            return false;
        }
        PsiType psiType = substituted = substitutor != null ? substitutor.substitute(baseType) : baseType;
        if (GdkMethodUtil.COLLECTION_METHOD_NAMES.contains(name)) {
            return !(type instanceof PsiArrayType) && !InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.Iterable") && !(substituted instanceof PsiArrayType) && !InheritanceUtil.isInheritor((PsiType)substituted, (String)"java.lang.Iterable");
        }
        return !GdkMethodUtil.isWithName(name);
    }

    public static boolean isWildcardCompletion(PsiElement position) {
        PsiElement prev = GeeseUtil.getPreviousNonWhitespaceToken(position);
        if (prev instanceof PsiErrorElement) {
            prev = GeeseUtil.getPreviousNonWhitespaceToken(prev);
        }
        if (prev == null || prev.getNode().getElementType() != GroovyTokenTypes.mQUESTION) {
            return false;
        }
        PsiElement pprev = GeeseUtil.getPreviousNonWhitespaceToken(prev);
        if (pprev == null) {
            return false;
        }
        IElementType t = pprev.getNode().getElementType();
        return t == GroovyTokenTypes.mLT || t == GroovyTokenTypes.mCOMMA;
    }

    public static List<LookupElement> getAnnotationCompletionResults(GrAnnotation anno, PrefixMatcher matcher) {
        GrCodeReferenceElement ref;
        PsiElement resolved;
        if (anno != null && (resolved = (ref = anno.getClassReference()).resolve()) instanceof PsiClass) {
            PsiAnnotation annotationCollector = GrAnnotationCollector.findAnnotationCollector((PsiClass)resolved);
            if (annotationCollector != null) {
                ArrayList annotations = ContainerUtil.newArrayList();
                GrAnnotationCollector.collectAnnotations(annotations, anno, annotationCollector);
                HashSet usedNames = ContainerUtil.newHashSet();
                ArrayList<LookupElement> result = new ArrayList<LookupElement>();
                for (GrAnnotation annotation : annotations) {
                    PsiElement resolvedAliased = annotation.getClassReference().resolve();
                    if (!(resolvedAliased instanceof PsiClass) || !((PsiClass)resolvedAliased).isAnnotationType()) continue;
                    for (PsiMethod method : ((PsiClass)resolvedAliased).getMethods()) {
                        if (!usedNames.add(method.getName())) continue;
                        result.addAll(GroovyCompletionUtil.createLookupElements(new GroovyResolveResultImpl((PsiElement)method, true), false, matcher, null));
                    }
                }
                return result;
            }
            if (((PsiClass)resolved).isAnnotationType()) {
                ArrayList<LookupElement> result = new ArrayList<LookupElement>();
                for (PsiMethod method : ((PsiClass)resolved).getMethods()) {
                    result.addAll(GroovyCompletionUtil.createLookupElements(new GroovyResolveResultImpl((PsiElement)method, true), false, matcher, null));
                }
                return result;
            }
        }
        return Collections.emptyList();
    }

    static boolean isNewStatementInScript(PsiElement context) {
        PsiElement parent;
        PsiElement leaf = GroovyCompletionUtil.getLeafByOffset(context.getTextRange().getStartOffset() - 1, context);
        return leaf != null && GroovyCompletionUtil.isNewStatement(context, false) && (parent = leaf.getParent()) instanceof GroovyFile;
    }

    public static boolean isReferenceElementInNewExpr(PsiElement context) {
        PsiElement pparent;
        return context.getParent() instanceof GrCodeReferenceElement && (pparent = context.getParent().getParent()) instanceof GrNewExpression;
    }

    static boolean isCodeReferenceElementApplicableToModifierCompletion(PsiElement context) {
        return context.getParent() instanceof GrCodeReferenceElement && !(context.getParent().getParent() instanceof GrImportStatement) && !(context.getParent().getParent() instanceof GrPackageDefinition) && !(context.getParent().getParent() instanceof GrNewExpression);
    }

    static boolean isTypelessParameter(PsiElement context) {
        return context.getParent() instanceof GrParameter && ((GrParameter)context.getParent()).getTypeElementGroovy() == null;
    }

    public static boolean isTupleVarNameWithoutTypeDeclared(PsiElement position) {
        PsiElement parent = position.getParent();
        PsiElement pparent = parent.getParent();
        return parent instanceof GrVariable && ((GrVariable)parent).getNameIdentifierGroovy() == position && ((GrVariable)parent).getTypeElementGroovy() == null && pparent instanceof GrVariableDeclaration && ((GrVariableDeclaration)pparent).isTuple();
    }
}

