/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaChainLookupElement;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import java.util.ArrayList;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrMethodMergingContributor
extends CompletionContributor {
    public AutoCompletionDecision handleAutoCompletionPossibility(AutoCompletionContext context) {
        CompletionParameters parameters = context.getParameters();
        if (parameters.getCompletionType() != CompletionType.SMART && parameters.getCompletionType() != CompletionType.BASIC) {
            return null;
        }
        boolean needInsertBrace = false;
        boolean needInsertParenth = false;
        LookupElement[] items = context.getItems();
        if (items.length > 1) {
            String commonName = null;
            LookupElement best = null;
            ArrayList<PsiMethod> allMethods = new ArrayList<PsiMethod>();
            for (LookupElement item : items) {
                Object o = item.getObject();
                if (o instanceof ResolveResult) {
                    o = ((ResolveResult)o).getElement();
                }
                if (item.getUserData(LookupItem.FORCE_SHOW_SIGNATURE_ATTR) != null || !(o instanceof PsiMethod)) {
                    return AutoCompletionDecision.SHOW_LOOKUP;
                }
                PsiMethod method = (PsiMethod)o;
                JavaChainLookupElement chain = (JavaChainLookupElement)item.as(JavaChainLookupElement.CLASS_CONDITION_KEY);
                String name = method.getName() + "#" + (chain == null ? "" : chain.getQualifier().getLookupString());
                if (commonName != null && !commonName.equals(name)) {
                    return AutoCompletionDecision.SHOW_LOOKUP;
                }
                if (GrMethodMergingContributor.hasOnlyClosureParams(method)) {
                    needInsertBrace = true;
                } else {
                    needInsertParenth = true;
                }
                if (needInsertBrace && needInsertParenth) {
                    return AutoCompletionDecision.SHOW_LOOKUP;
                }
                if (best == null && method.getParameterList().getParametersCount() > 0) {
                    best = item;
                }
                commonName = name;
                allMethods.add(method);
                item.putUserData(JavaCompletionUtil.ALL_METHODS_ATTRIBUTE, allMethods);
            }
            if (best == null) {
                best = items[0];
            }
            return AutoCompletionDecision.insertItem(best);
        }
        return super.handleAutoCompletionPossibility(context);
    }

    private static boolean hasOnlyClosureParams(PsiMethod method) {
        PsiParameter[] params;
        for (PsiParameter param : params = method.getParameterList().getParameters()) {
            PsiType type = param.getType();
            if (TypesUtil.isClassType(type, "groovy.lang.Closure")) continue;
            return false;
        }
        return params.length > 0;
    }
}

