/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentProvider;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ResolverProcessor;

public class GroovyConstructorNamedArgumentProvider
extends GroovyNamedArgumentProvider {
    private static final String METACLASS = "metaClass";

    @Override
    public void getNamedArguments(@NotNull GrCall call, @Nullable PsiElement resolve, @Nullable String argumentName, boolean forCompletion, Map<String, NamedArgumentDescriptor> result) {
        GrNewExpression newCall;
        GrArgumentList argumentList;
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/GroovyConstructorNamedArgumentProvider", "getNamedArguments"));
        }
        if (!(call instanceof GrNewExpression)) {
            return;
        }
        if (resolve != null) {
            if (!(resolve instanceof PsiMethod)) {
                return;
            }
            PsiMethod method = (PsiMethod)resolve;
            if (!method.isConstructor()) {
                return;
            }
        }
        if ((argumentList = (newCall = (GrNewExpression)call).getArgumentList()) == null) {
            return;
        }
        GrExpression[] expressionArguments = argumentList.getExpressionArguments();
        if (expressionArguments.length > 1 || expressionArguments.length == 1 && !(expressionArguments[0] instanceof GrReferenceExpression)) {
            return;
        }
        for (GroovyResolveResult resolveResult : newCall.multiResolveClass()) {
            PsiClass aClass;
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiClass) || !GroovyConstructorNamedArgumentProvider.isClassHasConstructorWithMap(aClass = (PsiClass)element)) continue;
            PsiClassType classType = JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass);
            GroovyConstructorNamedArgumentProvider.processClass(call, classType, argumentName, result);
        }
    }

    public static void processClass(@NotNull GrCall call, PsiClassType type, @Nullable String argumentName, final Map<String, NamedArgumentDescriptor> result) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/GroovyConstructorNamedArgumentProvider", "processClass"));
        }
        if (argumentName == null) {
            final HashMap map = ContainerUtil.newHashMap();
            MyPsiScopeProcessor processor = new MyPsiScopeProcessor(){

                @Override
                protected void addNamedArgument(String propertyName, PsiType type, PsiElement element, PsiSubstitutor substitutor) {
                    if (result.containsKey(propertyName)) {
                        return;
                    }
                    Trinity pair = (Trinity)map.get(propertyName);
                    if (!(pair == null || element instanceof PsiMethod && pair.second instanceof PsiField)) {
                        return;
                    }
                    map.put(propertyName, Trinity.create((Object)type, (Object)element, (Object)substitutor));
                }
            };
            processor.setResolveTargetKinds(ResolverProcessor.RESOLVE_KINDS_METHOD_PROPERTY);
            ResolveUtil.processAllDeclarations((PsiType)type, processor, ResolveState.initial(), call);
            for (Map.Entry entry : map.entrySet()) {
                result.put((String)entry.getKey(), new NamedArgumentDescriptor.TypeCondition((PsiType)((Trinity)entry.getValue()).first, (PsiElement)((Trinity)entry.getValue()).getSecond(), (PsiSubstitutor)((Trinity)entry.getValue()).getThird()).setPriority(NamedArgumentDescriptor.Priority.AS_LOCAL_VARIABLE));
            }
        } else {
            MyPsiScopeProcessor processor = new MyPsiScopeProcessor(){

                @Override
                protected void addNamedArgument(String propertyName, PsiType type, PsiElement element, PsiSubstitutor substitutor) {
                    if (result.containsKey(propertyName)) {
                        return;
                    }
                    result.put(propertyName, new NamedArgumentDescriptor.TypeCondition(type, element, substitutor).setPriority(NamedArgumentDescriptor.Priority.AS_LOCAL_VARIABLE));
                }
            };
            processor.setResolveTargetKinds(ResolverProcessor.RESOLVE_KINDS_METHOD);
            processor.setNameHint(GroovyPropertyUtils.getSetterName(argumentName));
            ResolveUtil.processAllDeclarations((PsiType)type, processor, ResolveState.initial(), call);
            processor.setResolveTargetKinds(ResolverProcessor.RESOLVE_KINDS_PROPERTY);
            processor.setNameHint(argumentName);
            ResolveUtil.processAllDeclarations((PsiType)type, processor, ResolveState.initial(), call);
        }
    }

    private static boolean isClassHasConstructorWithMap(PsiClass aClass) {
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return true;
        }
        for (PsiMethod constructor : constructors) {
            PsiParameterList parameterList = constructor.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            if (parameters.length == 0) {
                return true;
            }
            PsiParameter first = parameters[0];
            if (InheritanceUtil.isInheritor((PsiType)first.getType(), (String)"java.util.Map")) {
                return true;
            }
            if (first instanceof GrParameter && ((GrParameter)first).getTypeGroovy() == null) {
                return true;
            }
            if (PsiUtil.isConstructorHasRequiredParameters(constructor)) continue;
            return true;
        }
        return false;
    }

    private static abstract class MyPsiScopeProcessor
    implements PsiScopeProcessor,
    NameHint,
    ClassHint,
    ElementClassHint {
        private String myNameHint;
        private EnumSet<ClassHint.ResolveKind> myResolveTargetKinds;

        private MyPsiScopeProcessor() {
        }

        public boolean execute(@NotNull PsiElement element, ResolveState state) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/GroovyConstructorNamedArgumentProvider$MyPsiScopeProcessor", "execute"));
            }
            if (element instanceof PsiMethod || element instanceof PsiField) {
                PsiType type;
                String propertyName;
                if (element instanceof PsiMethod) {
                    if (!this.myResolveTargetKinds.contains((Object)ClassHint.ResolveKind.METHOD)) {
                        return true;
                    }
                    PsiMethod method = (PsiMethod)element;
                    if (!GroovyPropertyUtils.isSimplePropertySetter(method)) {
                        return true;
                    }
                    propertyName = GroovyPropertyUtils.getPropertyNameBySetter(method);
                    if (propertyName == null) {
                        return true;
                    }
                    type = method.getParameterList().getParameters()[0].getType();
                } else {
                    if (!this.myResolveTargetKinds.contains((Object)ClassHint.ResolveKind.PROPERTY)) {
                        return true;
                    }
                    type = ((PsiField)element).getType();
                    propertyName = ((PsiField)element).getName();
                }
                if (propertyName.equals(GroovyConstructorNamedArgumentProvider.METACLASS)) {
                    return true;
                }
                if (((PsiModifierListOwner)element).hasModifierProperty("static")) {
                    return true;
                }
                PsiSubstitutor substitutor = (PsiSubstitutor)state.get(PsiSubstitutor.KEY);
                if (substitutor != null) {
                    type = substitutor.substitute(type);
                }
                this.addNamedArgument(propertyName, type, element, substitutor);
            }
            return true;
        }

        protected abstract void addNamedArgument(String var1, PsiType var2, PsiElement var3, PsiSubstitutor var4);

        public <T> T getHint(@NotNull Key<T> hintKey) {
            if (hintKey == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/lang/GroovyConstructorNamedArgumentProvider$MyPsiScopeProcessor", "getHint"));
            }
            if (NameHint.KEY == hintKey && this.myNameHint != null || ClassHint.KEY == hintKey || ElementClassHint.KEY == hintKey) {
                return (T)this;
            }
            return null;
        }

        public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        }

        @Override
        public boolean shouldProcess(ClassHint.ResolveKind resolveKind) {
            return this.myResolveTargetKinds.contains((Object)resolveKind);
        }

        public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
            switch (kind) {
                case CLASS: {
                    return this.shouldProcess(ClassHint.ResolveKind.CLASS);
                }
                case ENUM_CONST: 
                case VARIABLE: 
                case FIELD: {
                    return this.shouldProcess(ClassHint.ResolveKind.PROPERTY);
                }
                case METHOD: {
                    return this.shouldProcess(ClassHint.ResolveKind.METHOD);
                }
                case PACKAGE: {
                    return this.shouldProcess(ClassHint.ResolveKind.PACKAGE);
                }
            }
            return false;
        }

        public String getName(ResolveState state) {
            return this.myNameHint;
        }

        public void setNameHint(String nameHint) {
            this.myNameHint = nameHint;
        }

        public void setResolveTargetKinds(EnumSet<ClassHint.ResolveKind> resolveTargetKinds) {
            this.myResolveTargetKinds = resolveTargetKinds;
        }
    }
}

