/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.utils;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;

public class DuplicatesUtil {
    public static void collectMethodDuplicates(Map<GrMethod, List<GrMethod>> map, HashSet<GrMethod> duplicateMethodsWarning, HashSet<GrMethod> duplicateMethodsErrors) {
        for (GrMethod method : map.keySet()) {
            List<GrMethod> duplicateMethods = map.get(method);
            if (duplicateMethods == null || duplicateMethods.size() <= 1) continue;
            HashMap<PsiPrimitiveType, GrMethod> duplicateMethodsToReturnTypeMap = new HashMap<PsiPrimitiveType, GrMethod>();
            for (GrMethod duplicateMethod : duplicateMethods) {
                GrTypeElement typeElement = duplicateMethod.getReturnTypeElementGroovy();
                Object methodReturnType = typeElement != null ? typeElement.getType() : PsiType.NULL;
                duplicateMethodsWarning.add(duplicateMethod);
                GrMethod grMethodWithType = (GrMethod)duplicateMethodsToReturnTypeMap.get(methodReturnType);
                if (grMethodWithType != null) {
                    duplicateMethodsErrors.add(duplicateMethod);
                    duplicateMethodsErrors.add(grMethodWithType);
                    duplicateMethodsWarning.remove(duplicateMethod);
                    duplicateMethodsWarning.remove(grMethodWithType);
                }
                duplicateMethodsToReturnTypeMap.put((PsiPrimitiveType)methodReturnType, duplicateMethod);
            }
        }
    }

    public static <D extends PsiElement> Map<D, List<D>> factorDuplicates(D[] elements, TObjectHashingStrategy<D> strategy) {
        if (elements == null || elements.length == 0) {
            return Collections.emptyMap();
        }
        THashMap map = new THashMap(strategy);
        for (D element : elements) {
            ArrayList<D> list = (ArrayList<D>)map.get(element);
            if (list == null) {
                list = new ArrayList<D>();
            }
            list.add(element);
            map.put(element, list);
        }
        return map;
    }
}

