/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.utils;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.utils.ComparisonUtils;
import org.jetbrains.plugins.groovy.intentions.utils.ParenthesesUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class BoolUtils {
    private BoolUtils() {
    }

    public static boolean isNegated(GrExpression exp) {
        GrUnaryExpression prefixAncestor;
        IElementType sign;
        GrExpression ancestor = exp;
        while (ancestor.getParent() instanceof GrParenthesizedExpression) {
            ancestor = (GrExpression)ancestor.getParent();
        }
        return ancestor.getParent() instanceof GrUnaryExpression && GroovyTokenTypes.mLNOT.equals(sign = (prefixAncestor = (GrUnaryExpression)ancestor.getParent()).getOperationTokenType());
    }

    @Nullable
    public static GrExpression findNegation(GrExpression exp) {
        GrUnaryExpression prefixAncestor;
        IElementType sign;
        GrExpression ancestor = exp;
        while (ancestor.getParent() instanceof GrParenthesizedExpression) {
            ancestor = (GrExpression)ancestor.getParent();
        }
        if (ancestor.getParent() instanceof GrUnaryExpression && GroovyTokenTypes.mLNOT.equals(sign = (prefixAncestor = (GrUnaryExpression)ancestor.getParent()).getOperationTokenType())) {
            return prefixAncestor;
        }
        return null;
    }

    public static boolean isNegation(GrExpression exp) {
        if (!(exp instanceof GrUnaryExpression)) {
            return false;
        }
        GrUnaryExpression prefixExp = (GrUnaryExpression)exp;
        IElementType sign = prefixExp.getOperationTokenType();
        return GroovyTokenTypes.mLNOT.equals(sign);
    }

    public static GrExpression getNegated(GrExpression exp) {
        GrUnaryExpression prefixExp = (GrUnaryExpression)exp;
        GrExpression operand = prefixExp.getOperand();
        return (GrExpression)PsiUtil.skipParentheses(operand, false);
    }

    public static boolean isBooleanLiteral(GrExpression exp) {
        if (exp instanceof GrLiteral) {
            GrLiteral expression = (GrLiteral)exp;
            String text = expression.getText();
            return "true".equals(text) || "false".equals(text);
        }
        return false;
    }

    public static String getNegatedExpressionText(GrExpression condition) {
        if (BoolUtils.isNegation(condition)) {
            GrExpression negated = BoolUtils.getNegated(condition);
            return negated.getText();
        }
        if (ComparisonUtils.isComparison(condition)) {
            GrBinaryExpression binaryExpression = (GrBinaryExpression)condition;
            IElementType sign = binaryExpression.getOperationTokenType();
            String negatedComparison = ComparisonUtils.getNegatedComparison(sign);
            GrExpression lhs = binaryExpression.getLeftOperand();
            GrExpression rhs = binaryExpression.getRightOperand();
            assert (rhs != null);
            return lhs.getText() + negatedComparison + rhs.getText();
        }
        if (ParenthesesUtils.getPrecedence(condition) > ParenthesesUtils.PREFIX_PRECEDENCE) {
            return "!(" + condition.getText() + ')';
        }
        return '!' + condition.getText();
    }
}

