/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.style;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnnotationTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrInterfaceDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMembersDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringUtil;

public class RemoveUnnecessarySemicolonsIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = GroovyIntentionsBundle.message("remove.unnecessary.semicolons.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/style/RemoveUnnecessarySemicolonsIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyIntentionsBundle.message("remove.unnecessary.semicolons.family.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/style/RemoveUnnecessarySemicolonsIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement element;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/intentions/style/RemoveUnnecessarySemicolonsIntention", "isAvailable"));
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!(file instanceof GroovyFileBase)) {
            return false;
        }
        if (selectionModel.hasBlockSelection()) {
            return false;
        }
        if (selectionModel.hasSelection()) {
            HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(selectionModel.getSelectionStart());
            int end = selectionModel.getSelectionEnd();
            while (!iterator.atEnd()) {
                if (iterator.getTokenType() == GroovyTokenTypes.mSEMI) {
                    return true;
                }
                if (iterator.getStart() > end) {
                    return false;
                }
                iterator.advance();
            }
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset >= editor.getDocument().getTextLength()) {
            offset = editor.getDocument().getTextLength() - 1;
        }
        if ((element = file.findElementAt(offset)) == null) {
            return false;
        }
        if (element.getNode().getElementType() == GroovyTokenTypes.mSEMI) {
            return true;
        }
        PsiElement next = PsiTreeUtil.nextLeaf((PsiElement)element);
        if (next != null && next.getNode().getElementType() == GroovyTokenTypes.mSEMI) {
            return true;
        }
        PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)element);
        return prev != null && prev.getNode().getElementType() == GroovyTokenTypes.mSEMI;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/intentions/style/RemoveUnnecessarySemicolonsIntention", "invoke"));
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (selectionModel.hasBlockSelection()) {
            return;
        }
        Document document = editor.getDocument();
        if (selectionModel.hasSelection()) {
            int start = selectionModel.getSelectionStart();
            int end = selectionModel.getSelectionEnd();
            final TextRange range = new TextRange(start, end);
            final ArrayList semicolons = new ArrayList();
            file.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(PsiElement element) {
                    if (!range.intersects(element.getTextRange())) {
                        return;
                    }
                    IElementType elementType = element.getNode().getElementType();
                    if (elementType == GroovyTokenTypes.mSEMI) {
                        semicolons.add(element);
                    } else {
                        super.visitElement(element);
                    }
                }
            });
            boolean removed = false;
            for (PsiElement semicolon : semicolons) {
                removed = RemoveUnnecessarySemicolonsIntention.checkAndRemove(project, semicolon, document) || removed;
            }
            if (!removed) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)GroovyIntentionsBundle.message("no.unnecessary.semicolons.found", new Object[0]), (String)GroovyIntentionsBundle.message("remove.unnecessary.semicolons.name", new Object[0]), null);
            }
        } else {
            PsiElement element;
            int offset = editor.getCaretModel().getOffset();
            if (offset >= document.getTextLength()) {
                offset = document.getTextLength() - 1;
            }
            if ((element = file.findElementAt(offset)) == null) {
                return;
            }
            if (RemoveUnnecessarySemicolonsIntention.checkAndRemove(project, element, document)) {
                return;
            }
            if (RemoveUnnecessarySemicolonsIntention.checkAndRemove(project, PsiTreeUtil.nextLeaf((PsiElement)element), document)) {
                return;
            }
            if (RemoveUnnecessarySemicolonsIntention.checkAndRemove(project, PsiTreeUtil.prevLeaf((PsiElement)element), document)) {
                return;
            }
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)GroovyIntentionsBundle.message("no.unnecessary.semicolons.found", new Object[0]), (String)GroovyIntentionsBundle.message("remove.unnecessary.semicolons.name", new Object[0]), null);
        }
    }

    private static boolean checkAndRemove(Project project, @Nullable PsiElement element, Document document) {
        if (element != null && element.getNode().getElementType() == GroovyTokenTypes.mSEMI && RemoveUnnecessarySemicolonsIntention.isSemiColonUnnecessary(element, document.getText(), project)) {
            element.delete();
            return true;
        }
        return false;
    }

    private static boolean isSemiColonUnnecessary(PsiElement semicolon, String text, Project project) {
        PsiElement parent = semicolon.getParent();
        if (parent instanceof GrTraditionalForClause) {
            return false;
        }
        if (parent instanceof GrTypeDefinitionBody) {
            return RemoveUnnecessarySemicolonsIntention.isSemiColonUnnecessaryInClassBody(semicolon, text, project);
        }
        return RemoveUnnecessarySemicolonsIntention.isSemiColonUnnecessaryInCodeBlock(semicolon, text, project);
    }

    private static boolean isSemiColonUnnecessaryInCodeBlock(PsiElement semicolon, String text, Project project) {
        GrStatement prev = RemoveUnnecessarySemicolonsIntention.getPreviousStatement(semicolon, GrStatement.class);
        GrStatement next = RemoveUnnecessarySemicolonsIntention.getNextStatement(semicolon, GrStatement.class);
        if (prev == null || next == null) {
            return true;
        }
        int startOffset = prev.getTextRange().getStartOffset();
        int endOffset = next.getTextRange().getEndOffset();
        int offset = semicolon.getTextRange().getStartOffset();
        String statementWithoutSemicolon = text.substring(startOffset, offset) + text.substring(offset + 1, endOffset);
        GroovyFile file = GroovyPsiElementFactory.getInstance(project).createGroovyFile(statementWithoutSemicolon, false, null);
        GrStatement[] statements = file.getStatements();
        if (statements.length != 2) {
            return false;
        }
        return RemoveUnnecessarySemicolonsIntention.checkStatementsAreEqual(prev, statements[0]) && RemoveUnnecessarySemicolonsIntention.checkStatementsAreEqual(next, statements[1]);
    }

    private static boolean isSemiColonUnnecessaryInClassBody(PsiElement semicolon, String text, Project project) {
        GrMembersDeclaration prev = RemoveUnnecessarySemicolonsIntention.getPreviousStatement(semicolon, GrMembersDeclaration.class);
        GrMembersDeclaration next = RemoveUnnecessarySemicolonsIntention.getNextStatement(semicolon, GrMembersDeclaration.class);
        if (prev == null || next == null) {
            return true;
        }
        int startOffset = prev.getTextRange().getStartOffset();
        int endOffset = next.getTextRange().getEndOffset();
        int offset = semicolon.getTextRange().getStartOffset();
        String declarationsWithoutSemicolon = text.substring(startOffset, offset) + text.substring(offset + 1, endOffset);
        PsiElement parent = semicolon.getParent().getParent();
        String prefix = parent instanceof GrClassDefinition ? "class" : (parent instanceof GrEnumTypeDefinition ? "enum" : (parent instanceof GrInterfaceDefinition ? "interface" : (parent instanceof GrAnnotationTypeDefinition ? "@interface" : (parent instanceof GrAnonymousClassDefinition ? "class" : "class"))));
        GroovyFile file = GroovyPsiElementFactory.getInstance(project).createGroovyFile(prefix + " Name {\n" + declarationsWithoutSemicolon + "\n}", false, null);
        GrTypeDefinition[] typeDefs = file.getTypeDefinitions();
        if (typeDefs.length != 1) {
            return false;
        }
        GrTypeDefinition clazz = typeDefs[0];
        GrMembersDeclaration[] declarations = clazz.getMemberDeclarations();
        if (declarations.length != 2) {
            return false;
        }
        return RemoveUnnecessarySemicolonsIntention.checkStatementsAreEqual(prev, declarations[0]) && RemoveUnnecessarySemicolonsIntention.checkStatementsAreEqual(next, declarations[1]);
    }

    private static <T extends PsiElement> boolean checkStatementsAreEqual(T before, T after) {
        if (before instanceof GrConstructorInvocation) {
            return after instanceof GrMethodCall && before.getText().equals(after.getText());
        }
        return GroovyRefactoringUtil.checkPsiElementsAreEqual(before, after);
    }

    @Nullable
    private static <T extends PsiElement> T getPreviousStatement(PsiElement semicolon, Class<T> instanceOf) {
        PsiElement prev = PsiUtil.skipWhitespacesAndComments(semicolon.getPrevSibling(), false);
        if (instanceOf.isInstance(prev)) {
            return (T)prev;
        }
        return null;
    }

    @Nullable
    private static <T extends PsiElement> T getNextStatement(PsiElement semicolon, Class<T> instaceOf) {
        PsiElement next = PsiUtil.skipWhitespacesAndComments(semicolon.getNextSibling(), true);
        if (instaceOf.isInstance(next)) {
            return (T)next;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

