/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.declaration;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;

public abstract class GrChangeMemberVisibilityModifierBase
extends Intention {
    private final String myModifier;

    public GrChangeMemberVisibilityModifierBase(String modifier) {
        this.myModifier = modifier;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/intentions/declaration/GrChangeMemberVisibilityModifierBase", "processIntention"));
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof GrMember)) {
            return;
        }
        ((GrMember)parent).getModifierList().setModifierProperty(this.myModifier, true);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                PsiElement parent = element.getParent();
                return parent instanceof GrMember && parent instanceof GrNamedElement && (((GrNamedElement)parent).getNameIdentifierGroovy() == element || ((GrMember)parent).getModifierList() == element) && ((GrMember)parent).getModifierList() != null && !((GrMember)parent).getModifierList().hasExplicitModifier(GrChangeMemberVisibilityModifierBase.this.myModifier);
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/declaration/GrChangeMemberVisibilityModifierBase", "getElementPredicate"));
        }
        return psiElementPredicate;
    }
}

