/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions.strings;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GrBreakStringOnLineBreaksIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/intentions/conversions/strings/GrBreakStringOnLineBreaksIntention", "processIntention"));
        }
        String text = GrBreakStringOnLineBreaksIntention.invokeImpl(element);
        GrExpression newExpr = GroovyPsiElementFactory.getInstance(project).createExpressionFromText(text);
        ((GrExpression)element).replaceWithExpression(newExpr, true);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                return element instanceof GrLiteral && !element.getText().equals(GrBreakStringOnLineBreaksIntention.invokeImpl(element));
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/conversions/strings/GrBreakStringOnLineBreaksIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }

    private static String invokeImpl(PsiElement element) {
        String text = element.getText();
        String quote = GrStringUtil.getStartQuote(text);
        if (!"'".equals(quote) && !"\"".equals(quote)) {
            return text;
        }
        if (!text.contains("\\n")) {
            return text;
        }
        String value = GrStringUtil.removeQuotes(text);
        StringBuilder buffer = new StringBuilder();
        if (element instanceof GrString) {
            GrBreakStringOnLineBreaksIntention.processGString(element, quote, value, buffer);
        } else {
            GrBreakStringOnLineBreaksIntention.processSimpleString(quote, value, buffer);
        }
        String result = buffer.toString();
        if (result.endsWith("+\n\"\"")) {
            return result.substring(0, result.length() - 4);
        }
        return result;
    }

    private static void processGString(PsiElement element, String quote, String value, StringBuilder buffer) {
        ASTNode node = element.getNode();
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (type == GroovyElementTypes.mGSTRING_BEGIN || type == GroovyElementTypes.mGSTRING_END) continue;
            if (type == GroovyElementTypes.GSTRING_INJECTION) {
                buffer.append(child.getText());
                continue;
            }
            value = child.getText();
            int prev = 0;
            if (!GrBreakStringOnLineBreaksIntention.isInjection(child.getTreePrev())) {
                buffer.append(quote);
            }
            int pos = value.indexOf("\\n");
            while (pos >= 0) {
                int end = GrBreakStringOnLineBreaksIntention.checkForR(value, pos);
                buffer.append(value.substring(prev, end));
                prev = end;
                buffer.append(quote);
                buffer.append("+\n");
                buffer.append(quote);
                pos = value.indexOf("\\n", prev);
            }
            buffer.append(value.substring(prev, value.length()));
            if (GrBreakStringOnLineBreaksIntention.isInjection(child.getTreeNext())) continue;
            buffer.append(quote);
        }
    }

    private static boolean isInjection(ASTNode next) {
        return next != null && next.getElementType() == GroovyElementTypes.GSTRING_INJECTION;
    }

    private static void processSimpleString(String quote, String value, StringBuilder buffer) {
        int prev = 0;
        int pos = value.indexOf("\\n");
        while (pos >= 0) {
            buffer.append(quote);
            int end = GrBreakStringOnLineBreaksIntention.checkForR(value, pos);
            buffer.append(value.substring(prev, end));
            prev = end;
            buffer.append(quote);
            buffer.append("+\n");
            pos = value.indexOf("\\n", prev);
        }
        buffer.append(quote);
        buffer.append(value.substring(prev, value.length()));
        buffer.append(quote);
    }

    private static int checkForR(String value, int pos) {
        if (value.length() > (pos += 2) + 2 && "\r".equals(value.substring(pos, pos + 2))) {
            return pos + 2;
        }
        return pos;
    }
}

