/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.plugins.groovy.intentions.base.ErrorUtil;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;

class IndexedExpressionConversionPredicate
implements PsiElementPredicate {
    IndexedExpressionConversionPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof GrIndexProperty)) {
            return false;
        }
        if (ErrorUtil.containsError(element)) {
            return false;
        }
        GrIndexProperty arrayIndexExpression = (GrIndexProperty)element;
        PsiElement lastChild = arrayIndexExpression.getLastChild();
        if (!(lastChild instanceof GrArgumentList)) {
            return false;
        }
        GrArgumentList argList = (GrArgumentList)lastChild;
        GrExpression[] arguments = argList.getExpressionArguments();
        if (arguments.length != 1) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof GrAssignmentExpression)) {
            return true;
        }
        GrAssignmentExpression assignmentExpression = (GrAssignmentExpression)parent;
        GrExpression rvalue = assignmentExpression.getRValue();
        if (rvalue == null) {
            return false;
        }
        if (rvalue.equals(element)) {
            return true;
        }
        IElementType operator = assignmentExpression.getOperationTokenType();
        return GroovyTokenTypes.mASSIGN.equals(operator);
    }
}

