/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.comments;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.comments.CStyleCommentPredicate;

public class ChangeToEndOfLineCommentIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        CStyleCommentPredicate cStyleCommentPredicate = new CStyleCommentPredicate();
        if (cStyleCommentPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/comments/ChangeToEndOfLineCommentIntention", "getElementPredicate"));
        }
        return cStyleCommentPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element, Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/intentions/comments/ChangeToEndOfLineCommentIntention", "processIntention"));
        }
        PsiComment comment = (PsiComment)element;
        JavaPsiFacade manager = JavaPsiFacade.getInstance((Project)comment.getProject());
        PsiElement parent = comment.getParent();
        assert (parent != null);
        PsiElementFactory factory = manager.getElementFactory();
        String commentText = comment.getText();
        PsiElement whitespace = comment.getNextSibling();
        String text = commentText.substring(2, commentText.length() - 2);
        String[] lines = text.split("\n");
        for (int i = lines.length - 1; i >= 1; --i) {
            PsiComment nextComment = factory.createCommentFromText("//" + lines[i].trim() + '\n', parent);
            parent.addAfter((PsiElement)nextComment, (PsiElement)comment);
        }
        PsiComment newComment = factory.createCommentFromText("//" + lines[0], parent);
        comment.replace((PsiElement)newComment);
    }
}

