/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.highlighter;

import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.groovydoc.lexer.GroovyDocTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;

public class GroovyBraceMatcher
implements PairedBraceMatcher {
    private static final BracePair[] PAIRS = new BracePair[]{new BracePair(GroovyTokenTypes.mLPAREN, GroovyTokenTypes.mRPAREN, false), new BracePair(GroovyTokenTypes.mLBRACK, GroovyTokenTypes.mRBRACK, false), new BracePair(GroovyTokenTypes.mLCURLY, GroovyTokenTypes.mRCURLY, true), new BracePair(GroovyDocTokenTypes.mGDOC_INLINE_TAG_START, GroovyDocTokenTypes.mGDOC_INLINE_TAG_END, false), new BracePair(GroovyDocTokenTypes.mGDOC_TAG_VALUE_LPAREN, GroovyDocTokenTypes.mGDOC_TAG_VALUE_RPAREN, false), new BracePair(GroovyTokenTypes.mGSTRING_BEGIN, GroovyTokenTypes.mGSTRING_END, false), new BracePair(GroovyTokenTypes.mREGEX_BEGIN, GroovyTokenTypes.mREGEX_END, false), new BracePair(GroovyTokenTypes.mDOLLAR_SLASH_REGEX_BEGIN, GroovyTokenTypes.mDOLLAR_SLASH_REGEX_END, false)};

    public BracePair[] getPairs() {
        return PAIRS;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType braceType, @Nullable IElementType tokenType) {
        if (braceType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/highlighter/GroovyBraceMatcher", "isPairedBracesAllowedBeforeType"));
        }
        return tokenType == null || tokenType == TokenType.WHITE_SPACE || tokenType == GroovyTokenTypes.mSEMI || tokenType == GroovyTokenTypes.mCOMMA || tokenType == GroovyTokenTypes.mRPAREN || tokenType == GroovyTokenTypes.mRBRACK || tokenType == GroovyTokenTypes.mRCURLY || tokenType == GroovyTokenTypes.mGSTRING_BEGIN || tokenType == GroovyTokenTypes.mREGEX_BEGIN || tokenType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_BEGIN || TokenSets.COMMENT_SET.contains(tokenType) || tokenType.getLanguage() != GroovyFileType.GROOVY_LANGUAGE;
    }

    public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
        return openingBraceOffset;
    }
}

