/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.processors;

import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlock;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;

public class GroovyWrappingProcessor {
    private final ASTNode myNode;
    private final CommonCodeStyleSettings mySettings;
    private final IElementType myParentType;
    private final Wrap myCommonWrap;
    private final FormattingContext myContext;
    private boolean myUsedDefaultWrap = false;
    private static final TokenSet SKIP = TokenSet.create((IElementType[])new IElementType[]{GroovyElementTypes.mCOMMA, GroovyElementTypes.mQUESTION, GroovyElementTypes.mSEMI, GroovyElementTypes.mASSIGN, GroovyElementTypes.mBAND_ASSIGN, GroovyElementTypes.mBOR_ASSIGN, GroovyElementTypes.mBSR_ASSIGN, GroovyElementTypes.mBXOR_ASSIGN, GroovyElementTypes.mDIV_ASSIGN, GroovyElementTypes.mMINUS_ASSIGN, GroovyElementTypes.mMOD_ASSIGN, GroovyElementTypes.mPLUS_ASSIGN, GroovyElementTypes.mSL_ASSIGN, GroovyElementTypes.mSR_ASSIGN, GroovyElementTypes.mSTAR_ASSIGN, GroovyElementTypes.mSTAR_STAR_ASSIGN, GroovyElementTypes.mASSIGN, GroovyElementTypes.mBAND_ASSIGN, GroovyElementTypes.mBOR_ASSIGN, GroovyElementTypes.mBSR_ASSIGN, GroovyElementTypes.mBXOR_ASSIGN, GroovyElementTypes.mDIV_ASSIGN, GroovyElementTypes.mMINUS_ASSIGN, GroovyElementTypes.mMOD_ASSIGN, GroovyElementTypes.mPLUS_ASSIGN, GroovyElementTypes.mSL_ASSIGN, GroovyElementTypes.mSR_ASSIGN, GroovyElementTypes.mSTAR_ASSIGN, GroovyElementTypes.mSTAR_STAR_ASSIGN, GroovyElementTypes.mBAND, GroovyElementTypes.mBOR, GroovyElementTypes.mBXOR, GroovyElementTypes.mDIV, GroovyElementTypes.mEQUAL, GroovyElementTypes.mGE, GroovyElementTypes.mGT, GroovyElementTypes.mLOR, GroovyElementTypes.mLT, GroovyElementTypes.mLE, GroovyElementTypes.mMINUS, GroovyElementTypes.kAS, GroovyElementTypes.kIN, GroovyElementTypes.mMOD, GroovyElementTypes.mPLUS, GroovyElementTypes.mSTAR, GroovyElementTypes.mSTAR_STAR, GroovyElementTypes.mNOT_EQUAL, GroovyElementTypes.mCOMPARE_TO, GroovyElementTypes.mLAND, GroovyElementTypes.kINSTANCEOF, GroovyElementTypes.COMPOSITE_LSHIFT_SIGN, GroovyElementTypes.COMPOSITE_RSHIFT_SIGN, GroovyElementTypes.COMPOSITE_TRIPLE_SHIFT_SIGN, GroovyElementTypes.mREGEX_FIND, GroovyElementTypes.mREGEX_MATCH, GroovyElementTypes.mRANGE_INCLUSIVE, GroovyElementTypes.mRANGE_EXCLUSIVE, GroovyElementTypes.mBNOT, GroovyElementTypes.mLNOT, GroovyElementTypes.mMINUS, GroovyElementTypes.mDEC, GroovyElementTypes.mPLUS, GroovyElementTypes.mINC, GroovyElementTypes.mSPREAD_DOT, GroovyElementTypes.mOPTIONAL_DOT, GroovyElementTypes.mMEMBER_POINTER, GroovyElementTypes.mDOT, GroovyElementTypes.COMPOSITE_LSHIFT_SIGN, GroovyElementTypes.COMPOSITE_RSHIFT_SIGN, GroovyElementTypes.COMPOSITE_TRIPLE_SHIFT_SIGN, GroovyElementTypes.mLT, GroovyElementTypes.mGT, GroovyElementTypes.mLE, GroovyElementTypes.mGE, GroovyElementTypes.kIN, GroovyElementTypes.kIN, GroovyElementTypes.mCOLON, GroovyElementTypes.mGSTRING_CONTENT, GroovyElementTypes.mGSTRING_END, GroovyElementTypes.GSTRING_INJECTION, GroovyElementTypes.mREGEX_CONTENT, GroovyElementTypes.mREGEX_END, GroovyElementTypes.mDOLLAR_SLASH_REGEX_CONTENT, GroovyElementTypes.mDOLLAR_SLASH_REGEX_END});
    private TokenSet ANNOTATION_CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{GroovyElementTypes.CLASS_DEFINITION, GroovyElementTypes.INTERFACE_DEFINITION, GroovyElementTypes.ENUM_DEFINITION, GroovyElementTypes.ANNOTATION_DEFINITION, GroovyElementTypes.METHOD_DEFINITION, GroovyElementTypes.CONSTRUCTOR_DEFINITION, GroovyElementTypes.VARIABLE_DEFINITION, GroovyElementTypes.PARAMETER, GroovyElementTypes.ENUM_CONSTANT, GroovyElementTypes.IMPORT_STATEMENT});

    public GroovyWrappingProcessor(GroovyBlock block) {
        this.myContext = block.getContext();
        this.mySettings = this.myContext.getSettings();
        this.myNode = block.getNode();
        this.myParentType = this.myNode.getElementType();
        this.myCommonWrap = this.createCommonWrap();
    }

    public Wrap getChildWrap(ASTNode childNode) {
        int wrapType;
        ASTNode leftSibling;
        if (this.myContext.isInsidePlainGString()) {
            return GroovyWrappingProcessor.createNoneWrap();
        }
        IElementType childType = childNode.getElementType();
        if (SKIP.contains(childType)) {
            return GroovyWrappingProcessor.createNoneWrap();
        }
        if (!(this.myParentType != GroovyElementTypes.EXTENDS_CLAUSE && this.myParentType != GroovyElementTypes.IMPLEMENTS_CLAUSE || childType != GroovyElementTypes.kEXTENDS && childType != GroovyElementTypes.kIMPLEMENTS)) {
            return Wrap.createWrap((int)this.mySettings.EXTENDS_KEYWORD_WRAP, (boolean)true);
        }
        if (this.myParentType == GroovyElementTypes.ARGUMENTS && (childType == GroovyElementTypes.mLPAREN || childType == GroovyElementTypes.mRPAREN)) {
            return GroovyWrappingProcessor.createNoneWrap();
        }
        if (this.myParentType == GroovyElementTypes.THROW_CLAUSE && childType == GroovyElementTypes.kTHROWS) {
            return Wrap.createWrap((int)this.mySettings.THROWS_KEYWORD_WRAP, (boolean)true);
        }
        if (this.myParentType == GroovyElementTypes.MODIFIERS) {
            if (GroovyWrappingProcessor.getLeftSiblingType(childNode) == GroovyElementTypes.ANNOTATION) {
                return this.getCommonWrap();
            }
            return GroovyWrappingProcessor.createNormalWrap();
        }
        if (this.ANNOTATION_CONTAINERS.contains(this.myParentType) && (leftSibling = GroovyWrappingProcessor.getLeftSibling(childNode)) != null && leftSibling.getElementType() == GroovyElementTypes.MODIFIERS && GroovyWrappingProcessor.endsWithAnnotation(leftSibling) && (wrapType = this.getAnnotationsWrapType(childNode)) != -1) {
            return Wrap.createWrap((int)wrapType, (boolean)true);
        }
        return this.getCommonWrap();
    }

    @Nullable
    private static IElementType getLeftSiblingType(ASTNode node) {
        ASTNode prev = GroovyWrappingProcessor.getLeftSibling(node);
        return prev != null ? prev.getElementType() : null;
    }

    private static ASTNode getLeftSibling(ASTNode node) {
        ASTNode prev;
        for (prev = node.getTreePrev(); prev != null && StringUtil.isEmptyOrSpaces((String)prev.getText()); prev = prev.getTreePrev()) {
        }
        return prev;
    }

    private static boolean endsWithAnnotation(ASTNode modifierListNode) {
        PsiElement psi = modifierListNode.getPsi();
        return psi instanceof GrModifierList && psi.getLastChild() instanceof GrAnnotation;
    }

    private Wrap getCommonWrap() {
        if (this.myCommonWrap == null) {
            return GroovyWrappingProcessor.createNoneWrap();
        }
        if (this.myUsedDefaultWrap) {
            return this.myCommonWrap;
        }
        this.myUsedDefaultWrap = true;
        return GroovyWrappingProcessor.createNoneWrap();
    }

    private static Wrap createNormalWrap() {
        return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
    }

    private static Wrap createNoneWrap() {
        return Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
    }

    @Nullable
    private Wrap createCommonWrap() {
        int wrapType;
        if (this.myParentType == GroovyElementTypes.EXTENDS_CLAUSE || this.myParentType == GroovyElementTypes.IMPLEMENTS_CLAUSE) {
            this.myUsedDefaultWrap = true;
            return Wrap.createWrap((int)this.mySettings.EXTENDS_LIST_WRAP, (boolean)true);
        }
        if (this.myParentType == GroovyElementTypes.THROW_CLAUSE) {
            this.myUsedDefaultWrap = true;
            return Wrap.createWrap((int)this.mySettings.THROWS_LIST_WRAP, (boolean)true);
        }
        if (this.myParentType == GroovyElementTypes.PARAMETERS_LIST) {
            this.myUsedDefaultWrap = true;
            return Wrap.createWrap((int)this.mySettings.METHOD_PARAMETERS_WRAP, (boolean)true);
        }
        if (this.myParentType == GroovyElementTypes.ARGUMENTS || this.myParentType == GroovyElementTypes.COMMAND_ARGUMENTS) {
            this.myUsedDefaultWrap = this.myParentType == GroovyElementTypes.ARGUMENTS;
            return Wrap.createWrap((int)this.mySettings.CALL_PARAMETERS_WRAP, (boolean)this.myUsedDefaultWrap);
        }
        if (this.myParentType == GroovyElementTypes.FOR_TRADITIONAL_CLAUSE || this.myParentType == GroovyElementTypes.FOR_IN_CLAUSE) {
            this.myUsedDefaultWrap = true;
            return Wrap.createWrap((int)this.mySettings.FOR_STATEMENT_WRAP, (boolean)true);
        }
        if (TokenSets.BINARY_EXPRESSIONS.contains(this.myParentType)) {
            return Wrap.createWrap((int)this.mySettings.BINARY_OPERATION_WRAP, (boolean)false);
        }
        if (this.myParentType == GroovyElementTypes.ASSIGNMENT_EXPRESSION) {
            return Wrap.createWrap((int)this.mySettings.ASSIGNMENT_WRAP, (boolean)false);
        }
        if (this.myParentType == GroovyElementTypes.CONDITIONAL_EXPRESSION || this.myParentType == GroovyElementTypes.ELVIS_EXPRESSION) {
            return Wrap.createWrap((int)this.mySettings.TERNARY_OPERATION_WRAP, (boolean)false);
        }
        if (this.myParentType == GroovyElementTypes.ASSERT_STATEMENT) {
            return Wrap.createWrap((int)this.mySettings.ASSERT_STATEMENT_WRAP, (boolean)false);
        }
        if (TokenSets.BLOCK_SET.contains(this.myParentType)) {
            return GroovyWrappingProcessor.createNormalWrap();
        }
        if (this.myParentType == GroovyElementTypes.MODIFIERS && (wrapType = this.getAnnotationsWrapType(this.myNode)) != -1) {
            this.myUsedDefaultWrap = true;
            return Wrap.createWrap((int)wrapType, (boolean)true);
        }
        return null;
    }

    public Wrap getChainedMethodCallWrap() {
        return this.myContext.isInsidePlainGString() ? Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false) : Wrap.createWrap((int)this.mySettings.METHOD_CALL_CHAIN_WRAP, (boolean)false);
    }

    private int getAnnotationsWrapType(ASTNode modifierList) {
        IElementType containerType = modifierList.getTreeParent().getElementType();
        if (GroovyElementTypes.TYPE_DEFINITION_TYPES.contains(containerType)) {
            return this.mySettings.CLASS_ANNOTATION_WRAP;
        }
        if (TokenSets.METHOD_DEFS.contains(containerType)) {
            return this.mySettings.METHOD_ANNOTATION_WRAP;
        }
        if (GroovyElementTypes.VARIABLE_DEFINITION == containerType) {
            IElementType pparentType = modifierList.getTreeParent().getTreeParent().getElementType();
            if (pparentType == GroovyElementTypes.CLASS_BODY || pparentType == GroovyElementTypes.ENUM_BODY) {
                return this.mySettings.FIELD_ANNOTATION_WRAP;
            }
            return this.mySettings.VARIABLE_ANNOTATION_WRAP;
        }
        if (GroovyElementTypes.PARAMETER == containerType) {
            return this.mySettings.PARAMETER_ANNOTATION_WRAP;
        }
        if (GroovyElementTypes.ENUM_CONSTANT == containerType) {
            return this.mySettings.ENUM_CONSTANTS_WRAP;
        }
        if (GroovyElementTypes.IMPORT_STATEMENT == containerType) {
            return this.myContext.getGroovySettings().IMPORT_ANNOTATION_WRAP;
        }
        return -1;
    }
}

