/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.formatter.blocks;

import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.formatter.FormattingContext;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlock;
import org.jetbrains.plugins.groovy.formatter.blocks.GroovyBlockGenerator;

public class ClosureBodyBlock
extends GroovyBlock {
    private TextRange myTextRange;

    public ClosureBodyBlock(@NotNull ASTNode node, @NotNull Indent indent, @Nullable Wrap wrap, FormattingContext context) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/formatter/blocks/ClosureBodyBlock", "<init>"));
        }
        if (indent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/formatter/blocks/ClosureBodyBlock", "<init>"));
        }
        super(node, indent, wrap, context);
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        this.init();
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/formatter/blocks/ClosureBodyBlock", "getTextRange"));
        }
        return textRange;
    }

    private void init() {
        if (this.mySubBlocks == null) {
            GroovyBlockGenerator generator = new GroovyBlockGenerator(this);
            List<ASTNode> children = GroovyBlockGenerator.getClosureBodyVisibleChildren(this.myNode.getTreeParent());
            this.mySubBlocks = generator.generateSubBlockForCodeBlocks(false, children, this.myContext.getGroovySettings().INDENT_LABEL_BLOCKS);
            assert (!this.mySubBlocks.isEmpty());
            TextRange firstRange = ((Block)this.mySubBlocks.get(0)).getTextRange();
            TextRange lastRange = ((Block)this.mySubBlocks.get(this.mySubBlocks.size() - 1)).getTextRange();
            this.myTextRange = new TextRange(firstRange.getStartOffset(), lastRange.getEndOffset());
        }
    }

    @Override
    @NotNull
    public List<Block> getSubBlocks() {
        this.init();
        List list = this.mySubBlocks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/formatter/blocks/ClosureBodyBlock", "getSubBlocks"));
        }
        return list;
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/formatter/blocks/ClosureBodyBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    @Override
    public boolean isIncomplete() {
        return true;
    }
}

