/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import org.jetbrains.plugins.groovy.GroovyFileTypeLoader;

public class GroovyScopeUtil {
    public static SearchScope restrictScopeToGroovyFiles(SearchScope originalScope) {
        if (originalScope instanceof GlobalSearchScope) {
            return GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)originalScope), (FileType[])GroovyFileTypeLoader.getGroovyEnabledFileTypes());
        }
        return originalScope;
    }

    public static SearchScope restrictScopeToGroovyFiles(SearchScope originalScope, SearchScope effectiveScope) {
        SearchScope restricted = GroovyScopeUtil.restrictScopeToGroovyFiles(originalScope);
        return originalScope.intersectWith(effectiveScope);
    }

    public static SearchScope getEffectiveScope(PsiMethod ... methods) {
        SearchScope accessScope = methods[0].getUseScope();
        for (int i = 1; i < methods.length; ++i) {
            PsiMethod method1 = methods[i];
            accessScope = accessScope.union(method1.getUseScope());
        }
        return accessScope;
    }
}

