/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.findUsages.GroovyWordsScanner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.refactoring.rename.PropertyForRename;

public class GroovyFindUsagesProvider
implements FindUsagesProvider {
    public static final GroovyFindUsagesProvider INSTANCE = new GroovyFindUsagesProvider();

    @Nullable
    public WordsScanner getWordsScanner() {
        return new GroovyWordsScanner();
    }

    public boolean canFindUsagesFor(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "canFindUsagesFor"));
        }
        return psiElement instanceof PsiClass || psiElement instanceof PsiMethod || psiElement instanceof GrVariable;
    }

    @Nullable
    public String getHelpId(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getHelpId"));
        }
        return null;
    }

    @NotNull
    public String getType(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getType"));
        }
        if (element instanceof PsiClass) {
            if ("class" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getType"));
            }
            return "class";
        }
        if (element instanceof PsiMethod) {
            if ("method" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getType"));
            }
            return "method";
        }
        if (element instanceof PsiField) {
            if ("field" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getType"));
            }
            return "field";
        }
        if (element instanceof PsiParameter) {
            if ("parameter" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getType"));
            }
            return "parameter";
        }
        if (element instanceof GrBindingVariable) {
            if ("script binding variable" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getType"));
            }
            return "script binding variable";
        }
        if (element instanceof PsiVariable) {
            if ("variable" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getType"));
            }
            return "variable";
        }
        if (element instanceof GrLabeledStatement) {
            if ("label" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getType"));
            }
            return "label";
        }
        if (element instanceof PropertyForRename) {
            if ("property" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getType"));
            }
            return "property";
        }
        if (element instanceof GrClosableBlock) {
            if ("closure" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getType"));
            }
            return "closure";
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getType"));
        }
        return "";
    }

    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getDescriptiveName"));
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            String qName = aClass.getQualifiedName();
            String string = qName == null ? "" : qName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            String result = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            PsiClass clazz = method.getContainingClass();
            if (clazz != null) {
                result = result + " of " + this.getDescriptiveName((PsiElement)clazz);
            }
            String string = result;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getDescriptiveName"));
            }
            return string;
        }
        if (element instanceof PsiVariable) {
            String name = ((PsiVariable)element).getName();
            if (name != null) {
                String string = name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getDescriptiveName"));
                }
                return string;
            }
        } else {
            if (element instanceof GrLabeledStatement) {
                String string = ((GrLabeledStatement)element).getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getDescriptiveName"));
                }
                return string;
            }
            if (element instanceof PropertyForRename) {
                String string = ((PropertyForRename)element).getPropertyName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getDescriptiveName"));
                }
                return string;
            }
            if (element instanceof GrClosableBlock) {
                if ("closure" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getDescriptiveName"));
                }
                return "closure";
            }
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getDescriptiveName"));
        }
        return "";
    }

    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getNodeText"));
        }
        if (element instanceof PsiClass) {
            String name = ((PsiClass)element).getQualifiedName();
            if (name == null || !useFullName) {
                name = ((PsiClass)element).getName();
            }
            if (name != null) {
                String string = name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getNodeText"));
                }
                return string;
            }
        } else {
            String name;
            if (element instanceof PsiMethod) {
                String string = PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)element), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getNodeText"));
                }
                return string;
            }
            if (element instanceof PsiVariable && (name = ((PsiVariable)element).getName()) != null) {
                String string = name;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getNodeText"));
                }
                return string;
            }
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/GroovyFindUsagesProvider", "getNodeText"));
        }
        return "";
    }
}

