/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMemberReference;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentHashSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.findUsages.GroovyScopeUtil;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorReference;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorSearcher;
import org.jetbrains.plugins.groovy.gpp.GppTypeConverter;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrTypeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;

public class GroovyConstructorUsagesSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    public static final Key<Set<PsiClass>> LITERALLY_CONSTRUCTED_CLASSES = Key.create((String)"LITERALLY_CONSTRUCTED_CLASSES");

    public GroovyConstructorUsagesSearcher() {
        super(true);
    }

    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters p, @NotNull Processor<PsiReference> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/findUsages/GroovyConstructorUsagesSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/findUsages/GroovyConstructorUsagesSearcher", "processQuery"));
        }
        GroovyConstructorUsagesSearcher.processConstructorUsages(p.getMethod(), p.getScope(), consumer, p.getOptimizer(), true, !p.isStrictSignatureSearch());
    }

    static void processConstructorUsages(final PsiMethod constructor, SearchScope searchScope, final Processor<PsiReference> consumer, SearchRequestCollector collector, boolean searchGppCalls, final boolean includeOverloads) {
        if (!constructor.isConstructor()) {
            return;
        }
        PsiClass clazz = constructor.getContainingClass();
        if (clazz == null) {
            return;
        }
        SearchScope onlyGroovy = GroovyScopeUtil.restrictScopeToGroovyFiles(searchScope, GroovyScopeUtil.getEffectiveScope(constructor));
        Set processed = (Set)collector.getSearchSession().getUserData(LITERALLY_CONSTRUCTED_CLASSES);
        if (processed == null) {
            processed = new ConcurrentHashSet();
            collector.getSearchSession().putUserData(LITERALLY_CONSTRUCTED_CLASSES, (Object)processed);
        }
        if (!processed.add(clazz)) {
            return;
        }
        if (clazz.isEnum() && clazz instanceof GroovyPsiElement) {
            for (PsiField field : clazz.getFields()) {
                PsiReference ref;
                if (!(field instanceof GrEnumConstant) || (ref = field.getReference()) == null || !ref.isReferenceTo((PsiElement)constructor) || consumer.process((Object)ref)) continue;
                return;
            }
        }
        LiteralConstructorSearcher literalProcessor = new LiteralConstructorSearcher(constructor, consumer, includeOverloads);
        Processor<GrNewExpression> newExpressionProcessor = new Processor<GrNewExpression>(){

            public boolean process(GrNewExpression grNewExpression) {
                PsiMethod resolvedConstructor = grNewExpression.resolveMethod();
                if (includeOverloads || constructor.getManager().areElementsEquivalent((PsiElement)resolvedConstructor, (PsiElement)constructor)) {
                    return consumer.process((Object)grNewExpression.getReferenceElement());
                }
                return true;
            }
        };
        GroovyConstructorUsagesSearcher.processGroovyClassUsages(clazz, searchScope, collector, searchGppCalls, newExpressionProcessor, literalProcessor);
        if (clazz instanceof GrTypeDefinition && !GroovyConstructorUsagesSearcher.processConstructors(constructor, consumer, clazz, true)) {
            return;
        }
        DirectClassInheritorsSearch.search((PsiClass)clazz, (SearchScope)onlyGroovy).forEach((Processor)new ReadActionProcessor<PsiClass>(){

            public boolean processInReadAction(PsiClass inheritor) {
                return !(inheritor instanceof GrTypeDefinition) || GroovyConstructorUsagesSearcher.processConstructors(constructor, (Processor<PsiReference>)consumer, inheritor, false);
            }
        });
    }

    public static void processGroovyClassUsages(final PsiClass clazz, SearchScope scope, SearchRequestCollector collector, final boolean searchGppCalls, final Processor<GrNewExpression> newExpressionProcessor, final LiteralConstructorSearcher literalProcessor) {
        ConcurrentHashSet processedMethods = new ConcurrentHashSet();
        ReferencesSearch.searchOptimized((PsiElement)clazz, (SearchScope)scope, (boolean)true, (SearchRequestCollector)collector, (boolean)true, (PairProcessor)new PairProcessor<PsiReference, SearchRequestCollector>((Set)processedMethods, scope){
            final /* synthetic */ Set val$processedMethods;
            final /* synthetic */ SearchScope val$scope;
            {
                this.val$processedMethods = set;
                this.val$scope = searchScope;
            }

            public boolean process(PsiReference ref, SearchRequestCollector collector) {
                PsiMethod method;
                PsiElement element = ref.getElement();
                if (element instanceof GrCodeReferenceElement && !GroovyConstructorUsagesSearcher.processGroovyConstructorUsages((GrCodeReferenceElement)element, !searchGppCalls, (Processor<GrNewExpression>)newExpressionProcessor, literalProcessor)) {
                    return false;
                }
                if (searchGppCalls && (method = GroovyConstructorUsagesSearcher.getMethodToSearchForCallsWithLiteralArguments(element, clazz)) != null && this.val$processedMethods.add(PsiAnchor.create((PsiElement)method))) {
                    GroovyConstructorUsagesSearcher.processGppMethodCalls(clazz, this.val$scope, collector, method, literalProcessor);
                }
                return true;
            }
        });
    }

    @Nullable
    private static PsiMethod getMethodToSearchForCallsWithLiteralArguments(PsiElement element, PsiClass targetClass) {
        PsiParameter[] parameters;
        int idx;
        PsiMethod method;
        PsiParameter parameter = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameter.class);
        if (parameter != null && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parameter, PsiMethod.class)) != null && (idx = Arrays.asList(parameters = method.getParameterList().getParameters()).indexOf(parameter)) >= 0) {
            PsiType parameterType = parameter.getType();
            if (parameterType instanceof PsiArrayType && idx == parameters.length - 1) {
                parameterType = ((PsiArrayType)parameterType).getComponentType();
            }
            if (parameterType instanceof PsiClassType && method.getManager().areElementsEquivalent((PsiElement)targetClass, (PsiElement)((PsiClassType)parameterType).resolve())) {
                return method;
            }
        }
        return null;
    }

    private static void processGppMethodCalls(PsiClass targetClass, SearchScope scope, SearchRequestCollector originalCollector, @NotNull PsiMethod currentTarget, final LiteralConstructorSearcher literalProcessor) {
        if (currentTarget == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/findUsages/GroovyConstructorUsagesSearcher", "processGppMethodCalls"));
        }
        SearchScope gppScope = GroovyConstructorUsagesSearcher.getGppScope(targetClass.getProject()).intersectWith(scope);
        if (gppScope instanceof GlobalSearchScope) {
            String name = currentTarget.getName();
            if (PsiSearchHelper.SERVICE.getInstance((Project)currentTarget.getProject()).isCheapEnoughToSearch(name, (GlobalSearchScope)gppScope, null, null) == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
                return;
            }
        }
        ReadActionProcessor<PsiReference> gppCallProcessor = new ReadActionProcessor<PsiReference>(){

            @Nullable
            private GrExpression[] getCallArguments(PsiReference psiReference) {
                if (psiReference instanceof GrReferenceElement) {
                    GrArgumentList argList;
                    PsiElement parent = ((GrReferenceElement)psiReference).getParent();
                    if (parent instanceof GrCall && (argList = ((GrCall)parent).getArgumentList()) != null) {
                        return argList.getExpressionArguments();
                    }
                } else if (psiReference instanceof LiteralConstructorReference) {
                    return ((LiteralConstructorReference)psiReference).getCallArguments();
                }
                return null;
            }

            public boolean processInReadAction(PsiReference psiReference) {
                GrExpression[] arguments = this.getCallArguments(psiReference);
                if (arguments == null) {
                    return true;
                }
                boolean checkedTypedContext = false;
                for (GrExpression argument : arguments) {
                    if (!(argument instanceof GrListOrMap)) continue;
                    if (!checkedTypedContext) {
                        if (!GppTypeConverter.hasTypedContext(psiReference.getElement())) {
                            return true;
                        }
                        checkedTypedContext = true;
                    }
                    if (literalProcessor.processLiteral((GrListOrMap)argument, true)) continue;
                    return false;
                }
                return true;
            }
        };
        if (currentTarget.isConstructor()) {
            GroovyConstructorUsagesSearcher.processConstructorUsages(currentTarget, gppScope, (Processor<PsiReference>)gppCallProcessor, originalCollector, true, false);
        } else {
            MethodReferencesSearch.searchOptimized((PsiMethod)currentTarget, (SearchScope)gppScope, (boolean)true, (SearchRequestCollector)originalCollector, (Processor)gppCallProcessor);
        }
    }

    private static GlobalSearchScope getGppScope(final Project project) {
        return (GlobalSearchScope)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, (CachedValueProvider)new CachedValueProvider<GlobalSearchScope>(){

            public CachedValueProvider.Result<GlobalSearchScope> compute() {
                return CachedValueProvider.Result.create((Object)GroovyConstructorUsagesSearcher.calcGppScope(project), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT, ProjectRootManager.getInstance((Project)project)});
            }
        });
    }

    private static boolean processGroovyConstructorUsages(GrCodeReferenceElement element, boolean usualCallsOnly, Processor<GrNewExpression> newExpressionProcessor, final LiteralConstructorSearcher literalProcessor) {
        PsiElement parent = element.getParent();
        if (parent instanceof GrAnonymousClassDefinition) {
            parent = parent.getParent();
        }
        if (parent instanceof GrNewExpression) {
            return newExpressionProcessor.process((Object)((GrNewExpression)parent));
        }
        if (usualCallsOnly) {
            return true;
        }
        if (parent instanceof GrTypeElement) {
            GrTypeCastExpression cast;
            GrTypeElement typeElement = (GrTypeElement)parent;
            PsiElement grandpa = typeElement.getParent();
            if (grandpa instanceof GrVariableDeclaration) {
                GrVariable variable;
                GrVariable[] vars = ((GrVariableDeclaration)grandpa).getVariables();
                if (vars.length == 1 && !GroovyConstructorUsagesSearcher.checkLiteralInstantiation((variable = vars[0]).getInitializerGroovy(), literalProcessor)) {
                    return false;
                }
            } else if (grandpa instanceof GrMethod) {
                GrMethod method = (GrMethod)grandpa;
                if (typeElement == method.getReturnTypeElementGroovy()) {
                    ControlFlowUtils.visitAllExitPoints(method.getBlock(), new ControlFlowUtils.ExitPointVisitor(){

                        @Override
                        public boolean visitExitPoint(Instruction instruction, @Nullable GrExpression returnValue) {
                            return GroovyConstructorUsagesSearcher.checkLiteralInstantiation(returnValue, literalProcessor);
                        }
                    });
                }
            } else if (grandpa instanceof GrTypeCastExpression ? (cast = (GrTypeCastExpression)grandpa).getCastTypeElement() == typeElement && !GroovyConstructorUsagesSearcher.checkLiteralInstantiation(cast.getOperand(), literalProcessor) : grandpa instanceof GrSafeCastExpression && (cast = (GrSafeCastExpression)grandpa).getCastTypeElement() == typeElement && !GroovyConstructorUsagesSearcher.checkLiteralInstantiation(cast.getOperand(), literalProcessor)) {
                return false;
            }
        }
        return true;
    }

    private static GlobalSearchScope calcGppScope(Project project) {
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
        GlobalSearchScope maximal = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)allScope, (FileType[])new FileType[]{GroovyFileType.GROOVY_FILE_TYPE});
        DelegatingGlobalSearchScope gppExtensions = new DelegatingGlobalSearchScope(maximal, new Object[]{"groovy.gpp"}){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/findUsages/GroovyConstructorUsagesSearcher$7", "contains"));
                }
                return super.contains(file) && GppTypeConverter.isGppExtension(file.getExtension());
            }
        };
        PsiClass typed = JavaPsiFacade.getInstance((Project)project).findClass("groovy.lang.Typed", allScope);
        if (typed != null) {
            final HashSet files = new HashSet();
            AnnotatedElementsSearch.searchElements((PsiClass)typed, (SearchScope)maximal, (Class[])new Class[]{PsiModifierListOwner.class}).forEach((Processor)new Processor<PsiModifierListOwner>(){

                public boolean process(PsiModifierListOwner occurrence) {
                    ContainerUtil.addIfNotNull((Object)occurrence.getContainingFile().getVirtualFile(), (Collection)files);
                    return true;
                }
            });
            GlobalSearchScope withTypedAnno = GlobalSearchScope.filesScope((Project)project, files);
            return withTypedAnno.union((SearchScope)gppExtensions);
        }
        return gppExtensions;
    }

    private static boolean checkLiteralInstantiation(GrExpression expression, LiteralConstructorSearcher literalProcessor) {
        if (expression instanceof GrListOrMap) {
            return literalProcessor.processLiteral((GrListOrMap)expression, GppTypeConverter.hasTypedContext(expression));
        }
        return true;
    }

    private static boolean processConstructors(PsiMethod searchedConstructor, Processor<PsiReference> consumer, PsiClass clazz, boolean processThisRefs) {
        PsiMethod[] constructors = clazz.getConstructors();
        if (constructors.length == 0) {
            GroovyConstructorUsagesSearcher.processImplicitConstructorCall((PsiMember)clazz, consumer, searchedConstructor);
        }
        for (PsiMethod constructor : constructors) {
            GrOpenBlock block = ((GrMethod)constructor).getBlock();
            if (block == null) continue;
            GrStatement[] statements = block.getStatements();
            if (statements.length > 0 && statements[0] instanceof GrConstructorInvocation) {
                GrConstructorInvocation invocation = (GrConstructorInvocation)statements[0];
                if (invocation.isThisCall() != processThisRefs || !invocation.getManager().areElementsEquivalent((PsiElement)invocation.resolveMethod(), (PsiElement)searchedConstructor) || consumer.process((Object)invocation.getInvokedExpression())) continue;
                return false;
            }
            GroovyConstructorUsagesSearcher.processImplicitConstructorCall((PsiMember)constructor, consumer, searchedConstructor);
        }
        return true;
    }

    private static void processImplicitConstructorCall(final PsiMember usage, Processor<PsiReference> processor, PsiMethod constructor) {
        GrParameter[] grParameters;
        if (constructor instanceof GrMethod ? (grParameters = (GrParameter[])constructor.getParameterList().getParameters()).length > 0 && !grParameters[0].isOptional() : constructor.getParameterList().getParameters().length > 0) {
            return;
        }
        PsiManager manager = constructor.getManager();
        if (manager.areElementsEquivalent((PsiElement)usage, (PsiElement)constructor) || manager.areElementsEquivalent((PsiElement)constructor.getContainingClass(), (PsiElement)usage.getContainingClass())) {
            return;
        }
        processor.process((Object)new LightMemberReference(manager, usage, PsiSubstitutor.EMPTY){

            public PsiElement getElement() {
                return usage;
            }

            public TextRange getRangeInElement() {
                PsiIdentifier identifier;
                if (usage instanceof PsiClass) {
                    PsiIdentifier identifier2 = ((PsiClass)usage).getNameIdentifier();
                    if (identifier2 != null) {
                        return TextRange.from((int)identifier2.getStartOffsetInParent(), (int)identifier2.getTextLength());
                    }
                } else if (usage instanceof PsiMethod && (identifier = ((PsiMethod)usage).getNameIdentifier()) != null) {
                    return TextRange.from((int)identifier.getStartOffsetInParent(), (int)identifier.getTextLength());
                }
                return super.getRangeInElement();
            }
        });
    }
}

