/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.psi.PsiElement;
import org.jetbrains.plugins.groovy.findUsages.MissingMethodAndPropertyUtil;
import org.jetbrains.plugins.groovy.lang.completion.GroovyCompletionUtil;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GrImplicitUsageProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(PsiElement element) {
        GrParameter parameter;
        PsiElement scope;
        if (element instanceof GrMethod) {
            GrMethod method = (GrMethod)element;
            if (GroovyCompletionUtil.OPERATOR_METHOD_NAMES.contains(method.getName())) {
                return true;
            }
            if (MissingMethodAndPropertyUtil.isPropertyMissing(method)) {
                return true;
            }
            if (MissingMethodAndPropertyUtil.isMethodMissing(method)) {
                return true;
            }
        } else if (element instanceof GrParameter && (scope = (parameter = (GrParameter)element).getDeclarationScope()) instanceof GrMethod && (MissingMethodAndPropertyUtil.isMethodMissing((GrMethod)scope) || MissingMethodAndPropertyUtil.isPropertyMissing((GrMethod)scope))) {
            return true;
        }
        return false;
    }

    public boolean isImplicitRead(PsiElement element) {
        return false;
    }

    public boolean isImplicitWrite(PsiElement element) {
        return false;
    }
}

