/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.search.AnnotatedElementsSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrAnnotatedMemberIndex;

public class AnnotatedMembersSearcher
implements QueryExecutor<PsiModifierListOwner, AnnotatedElementsSearch.Parameters> {
    @NotNull
    private static List<PsiModifierListOwner> getAnnotatedMemberCandidates(final PsiClass clazz, final GlobalSearchScope scope) {
        final String name = clazz.getName();
        if (name == null) {
            List<PsiModifierListOwner> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/AnnotatedMembersSearcher", "getAnnotatedMemberCandidates"));
            }
            return list;
        }
        Collection members = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<PsiElement>>(){

            public Collection<PsiElement> compute() {
                return StubIndex.getElements(GrAnnotatedMemberIndex.KEY, (Object)name, (Project)clazz.getProject(), (GlobalSearchScope)scope, PsiElement.class);
            }
        });
        if (members.isEmpty()) {
            List<PsiModifierListOwner> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/AnnotatedMembersSearcher", "getAnnotatedMemberCandidates"));
            }
            return list;
        }
        ArrayList<PsiModifierListOwner> result = new ArrayList<PsiModifierListOwner>();
        for (PsiElement element : members) {
            if (element instanceof GroovyFile) {
                element = ((GroovyFile)element).getPackageDefinition();
            }
            if (!(element instanceof PsiModifierListOwner)) continue;
            result.add((PsiModifierListOwner)element);
        }
        ArrayList<PsiModifierListOwner> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/findUsages/AnnotatedMembersSearcher", "getAnnotatedMemberCandidates"));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(@NotNull AnnotatedElementsSearch.Parameters p, @NotNull Processor<PsiModifierListOwner> consumer) {
        List<Object> candidates;
        String annotationFQN;
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/findUsages/AnnotatedMembersSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/findUsages/AnnotatedMembersSearcher", "execute"));
        }
        PsiClass annClass = p.getAnnotationClass();
        assert (annClass.isAnnotationType()) : "Annotation type should be passed to annotated members search";
        AccessToken token = ReadAction.start();
        try {
            annotationFQN = annClass.getQualifiedName();
        }
        finally {
            token.finish();
        }
        assert (annotationFQN != null);
        SearchScope scope = p.getScope();
        if (scope instanceof GlobalSearchScope) {
            candidates = AnnotatedMembersSearcher.getAnnotatedMemberCandidates(annClass, (GlobalSearchScope)scope);
        } else {
            candidates = new ArrayList();
            for (PsiElement element : ((LocalSearchScope)scope).getScope()) {
                if (!(element instanceof GroovyPsiElement)) continue;
                ((GroovyPsiElement)element).accept(new GroovyRecursiveElementVisitor(){

                    @Override
                    public void visitMethod(GrMethod method) {
                        candidates.add(method);
                    }

                    @Override
                    public void visitField(GrField field) {
                        candidates.add(field);
                    }
                });
            }
        }
        for (PsiModifierListOwner psiModifierListOwner : candidates) {
            token = ReadAction.start();
            try {
                PsiModifierList list;
                if (!AnnotatedElementsSearcher.isInstanceof((PsiElement)psiModifierListOwner, (Class[])p.getTypes()) || (list = psiModifierListOwner.getModifierList()) == null) continue;
                for (PsiAnnotation annotation : list.getAnnotations()) {
                    if (!annotationFQN.equals(annotation.getQualifiedName()) || consumer.process((Object)psiModifierListOwner)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                token.finish();
            }
        }
        return true;
    }
}

