/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.extensions;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiFile;
import icons.JetgroovyIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.extensions.GroovyScriptType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;

public abstract class GroovyScriptTypeDetector {
    public static final ExtensionPointName<GroovyScriptTypeDetector> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.scriptTypeDetector");
    private final GroovyScriptType myScriptType;
    private final String[] myExtensions;
    public static final GroovyScriptType DEFAULT_TYPE = new GroovyScriptType("default"){

        @Override
        public boolean shouldBeCompiled(GroovyFile script) {
            return true;
        }

        @Override
        @NotNull
        public Icon getScriptIcon() {
            Icon icon = JetgroovyIcons.Groovy.Groovy_16x16;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/extensions/GroovyScriptTypeDetector$1", "getScriptIcon"));
            }
            return icon;
        }

        @Override
        public GroovyScriptRunner getRunner() {
            return new DefaultGroovyScriptRunner();
        }
    };

    protected GroovyScriptTypeDetector(GroovyScriptType scriptType, String ... extensions) {
        this.myScriptType = scriptType;
        this.myExtensions = extensions;
    }

    @NotNull
    public final String[] getExtensions() {
        if (this.myExtensions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/extensions/GroovyScriptTypeDetector", "getExtensions"));
        }
        return this.myExtensions;
    }

    @NotNull
    public final GroovyScriptType getScriptType() {
        GroovyScriptType groovyScriptType = this.myScriptType;
        if (groovyScriptType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/extensions/GroovyScriptTypeDetector", "getScriptType"));
        }
        return groovyScriptType;
    }

    public abstract boolean isSpecificScriptFile(@NotNull GroovyFile var1);

    @NotNull
    public static GroovyScriptType getScriptType(@NotNull GroovyFile script) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/extensions/GroovyScriptTypeDetector", "getScriptType"));
        }
        for (GroovyScriptTypeDetector detector : (GroovyScriptTypeDetector[])EP_NAME.getExtensions()) {
            if (!detector.isSpecificScriptFile(script)) continue;
            GroovyScriptType groovyScriptType = detector.getScriptType();
            if (groovyScriptType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/extensions/GroovyScriptTypeDetector", "getScriptType"));
            }
            return groovyScriptType;
        }
        GroovyScriptType groovyScriptType = DEFAULT_TYPE;
        if (groovyScriptType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/extensions/GroovyScriptTypeDetector", "getScriptType"));
        }
        return groovyScriptType;
    }

    public static boolean isSpecificScriptFile(@NotNull PsiFile file, GroovyScriptType scriptType) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/extensions/GroovyScriptTypeDetector", "isSpecificScriptFile"));
        }
        if (!(file instanceof GroovyFile)) {
            return false;
        }
        if (!((GroovyFile)file).isScript()) {
            return false;
        }
        return GroovyScriptTypeDetector.isSpecificScriptFile((GroovyFile)file, scriptType);
    }

    public static boolean isSpecificScriptFile(@NotNull GroovyFile script, GroovyScriptType scriptType) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/extensions/GroovyScriptTypeDetector", "isSpecificScriptFile"));
        }
        assert (script.isScript());
        if (scriptType == DEFAULT_TYPE) {
            return GroovyScriptTypeDetector.getScriptType(script) == DEFAULT_TYPE;
        }
        for (GroovyScriptTypeDetector detector : (GroovyScriptTypeDetector[])EP_NAME.getExtensions()) {
            if (detector.getScriptType() != scriptType || !detector.isSpecificScriptFile(script)) continue;
            return true;
        }
        return false;
    }
}

