/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.editor.actions;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.editor.HandlerUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public class GStringTypedActionHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/editor/actions/GStringTypedActionHandler", "charTyped"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "org/jetbrains/plugins/groovy/editor/actions/GStringTypedActionHandler", "charTyped"));
        }
        if (c != '{' || project == null || !HandlerUtils.canBeInvoked(editor, project)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (!(file instanceof GroovyFile)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        int caret = editor.getCaretModel().getOffset();
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        if (caret < 1) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        HighlighterIterator iterator = highlighter.createIterator(caret - 1);
        if (iterator.getTokenType() != GroovyTokenTypes.mLCURLY) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        iterator.retreat();
        if (iterator.atEnd() || iterator.getTokenType() != GroovyTokenTypes.mDOLLAR) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        iterator.advance();
        if (iterator.atEnd()) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        iterator.advance();
        if (iterator.getTokenType() != GroovyTokenTypes.mGSTRING_BEGIN) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        editor.getDocument().insertString(caret, (CharSequence)"}");
        return TypedHandlerDelegate.Result.STOP;
    }
}

