/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.toplevel;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ConcurrentHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class ClassContextFilter
implements ContextFilter {
    private final Condition<Pair<PsiType, PsiFile>> myPattern;
    private static final Key<Map<String, PsiType>> CACHED_TYPES = Key.create((String)"Cached types");

    public ClassContextFilter(Condition<Pair<PsiType, PsiFile>> pattern) {
        this.myPattern = pattern;
    }

    @Override
    public boolean isApplicable(GroovyClassDescriptor descriptor, ProcessingContext ctx) {
        PsiFile place = descriptor.getPlaceFile();
        return this.myPattern.value((Object)Pair.create((Object)ClassContextFilter.findPsiType(descriptor, ctx), (Object)place));
    }

    @NotNull
    public static PsiType findPsiType(GroovyClassDescriptor descriptor, ProcessingContext ctx) {
        String typeText = descriptor.getTypeText();
        String key = ClassContextFilter.getClassKey(typeText);
        Object cached = ctx.get((Object)key);
        if (cached instanceof PsiType) {
            PsiType psiType = (PsiType)cached;
            if (psiType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/dsl/toplevel/ClassContextFilter", "findPsiType"));
            }
            return psiType;
        }
        PsiType found = JavaPsiFacade.getElementFactory((Project)descriptor.getProject()).createTypeFromText(typeText, (PsiElement)descriptor.getPlaceFile());
        ctx.put((Object)key, (Object)found);
        PsiType psiType = found;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/dsl/toplevel/ClassContextFilter", "findPsiType"));
        }
        return psiType;
    }

    public static String getClassKey(String fqName) {
        return "Class: " + fqName;
    }

    public static ClassContextFilter fromClassPattern(final ElementPattern pattern) {
        return new ClassContextFilter(new Condition<Pair<PsiType, PsiFile>>(){

            public boolean value(Pair<PsiType, PsiFile> pair) {
                PsiType type = (PsiType)pair.first;
                return type instanceof PsiClassType ? pattern.accepts((Object)((PsiClassType)type).resolve()) : false;
            }
        });
    }

    public static ClassContextFilter subtypeOf(final String typeText) {
        return new ClassContextFilter(new Condition<Pair<PsiType, PsiFile>>(){

            public boolean value(Pair<PsiType, PsiFile> p) {
                return ClassContextFilter.isSubtype((PsiType)p.first, (PsiFile)p.second, typeText);
            }
        });
    }

    public static boolean isSubtype(PsiType checked, PsiFile placeFile, String typeText) {
        PsiClass psiClass;
        boolean isClassType = checked instanceof PsiClassType;
        if (isClassType && (psiClass = ((PsiClassType)checked).resolve()) != null) {
            String rawName;
            int i = typeText.indexOf("<");
            String string = rawName = i > 0 ? typeText.substring(0, i) : typeText;
            if (!TypesUtil.getSuperClassesWithCache(psiClass).containsKey(rawName)) {
                return false;
            }
        }
        PsiType myType = ClassContextFilter.getCachedType(typeText, placeFile);
        if (checked == PsiType.NULL) {
            return myType == PsiType.NULL;
        }
        return TypesUtil.isAssignableByMethodCallConversion(myType, checked, (PsiElement)placeFile);
    }

    public static PsiType getCachedType(String typeText, PsiFile context) {
        PsiType type;
        Map map = (Map)context.getUserData(CACHED_TYPES);
        if (map == null) {
            map = new ConcurrentHashMap();
            context.putUserData(CACHED_TYPES, (Object)map);
        }
        if ((type = (PsiType)map.get(typeText)) == null || !type.isValid()) {
            type = JavaPsiFacade.getElementFactory((Project)context.getProject()).createTypeFromText(typeText, (PsiElement)context);
            map.put(typeText, type);
        }
        return type;
    }
}

