/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl.toplevel;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.toplevel.ContextFilter;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;

public class AnnotatedContextFilter
implements ContextFilter {
    private final String myAnnoQName;

    public AnnotatedContextFilter(String annoQName) {
        this.myAnnoQName = annoQName;
    }

    @Override
    public boolean isApplicable(GroovyClassDescriptor descriptor, ProcessingContext ctx) {
        return AnnotatedContextFilter.findContextAnnotation(descriptor.getPlace(), this.myAnnoQName) != null;
    }

    @Nullable
    public static PsiAnnotation findContextAnnotation(@NotNull PsiElement context, String annoQName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/dsl/toplevel/AnnotatedContextFilter", "findContextAnnotation"));
        }
        for (PsiElement current = context; current != null; current = current.getContext()) {
            GrPackageDefinition packageDefinition;
            if (current instanceof PsiModifierListOwner) {
                PsiAnnotation annotation;
                if (current instanceof GrVariableDeclaration || (annotation = AnnotatedContextFilter.findAnnotation(((PsiModifierListOwner)current).getModifierList(), annoQName)) == null) continue;
                return annotation;
            }
            if (!(current instanceof PsiFile)) continue;
            if (current instanceof GroovyFile && (packageDefinition = ((GroovyFile)current).getPackageDefinition()) != null) {
                return AnnotatedContextFilter.findAnnotation(packageDefinition.getAnnotationList(), annoQName);
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findAnnotation(PsiModifierList modifierList, String annoQName) {
        return modifierList != null ? modifierList.findAnnotation(annoQName) : null;
    }
}

