/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dsl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dsl.GdslMembersHolderConsumer;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.dsltop.GdslMembersProvider;
import org.jetbrains.plugins.groovy.dsl.holders.CompoundMembersHolder;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;
import org.jetbrains.plugins.groovy.dsl.holders.DeclarationType;
import org.jetbrains.plugins.groovy.dsl.holders.NonCodeMembersHolder;
import org.jetbrains.plugins.groovy.dsl.toplevel.ClassContextFilter;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class CustomMembersGenerator
extends GroovyObjectSupport
implements GdslMembersHolderConsumer {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.dsl.CustomMembersGenerator");
    private static final GdslMembersProvider[] PROVIDERS = (GdslMembersProvider[])GdslMembersProvider.EP_NAME.getExtensions();
    public static final String THROWS = "throws";
    private FList<Map> myDeclarations;
    private final Project myProject;
    private final CompoundMembersHolder myDepot;
    private final GroovyClassDescriptor myDescriptor;
    @Nullable
    private final Map<String, List> myBindings;
    private final PsiClass myPsiClass;

    public CustomMembersGenerator(@NotNull GroovyClassDescriptor descriptor, @Nullable PsiType type, @Nullable Map<String, List> bindings) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/dsl/CustomMembersGenerator", "<init>"));
        }
        this.myDeclarations = FList.emptyList();
        this.myDepot = new CompoundMembersHolder();
        this.myDescriptor = descriptor;
        this.myBindings = bindings;
        this.myProject = descriptor.getProject();
        this.myPsiClass = type instanceof PsiClassType ? ((PsiClassType)type).resolve() : null;
    }

    @Override
    public PsiElement getPlace() {
        return this.myDescriptor.getPlace();
    }

    @Override
    @Nullable
    public PsiClass getClassType() {
        return this.getPsiClass();
    }

    @Override
    public PsiType getPsiType() {
        return this.myDescriptor.getPsiType();
    }

    @Override
    @Nullable
    public PsiClass getPsiClass() {
        return this.myPsiClass;
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return this.myDescriptor.getResolveScope();
    }

    @Override
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public CustomMembersHolder getMembersHolder() {
        if (!this.myDeclarations.isEmpty()) {
            this.addMemberHolder(new CustomMembersHolder(){

                @Override
                public boolean processMembers(GroovyClassDescriptor descriptor, PsiScopeProcessor processor, ResolveState state) {
                    return NonCodeMembersHolder.generateMembers(ContainerUtil.reverse((List)CustomMembersGenerator.this.myDeclarations), descriptor.justGetPlaceFile()).processMembers(descriptor, processor, state);
                }
            });
        }
        return this.myDepot;
    }

    @Override
    public void addMemberHolder(CustomMembersHolder holder) {
        this.myDepot.addHolder(holder);
    }

    private Object[] constructNewArgs(Object[] args) {
        Object[] newArgs = new Object[args.length + 1];
        for (int i = 0; i < args.length; ++i) {
            newArgs[i] = args[i];
        }
        newArgs[args.length] = this;
        return newArgs;
    }

    public void property(Map<Object, Object> args) {
        if (args == null) {
            return;
        }
        String name = (String)args.get("name");
        Object type = args.get("type");
        Object doc = args.get("doc");
        Object docUrl = args.get("docUrl");
        Boolean isStatic = (Boolean)args.get("isStatic");
        HashMap<Object, Object> getter = new HashMap<Object, Object>();
        getter.put("name", GroovyPropertyUtils.getGetterNameNonBoolean(name));
        getter.put("type", type);
        getter.put("isStatic", isStatic);
        getter.put("doc", doc);
        getter.put("docUrl", docUrl);
        this.method(getter);
        HashMap<Object, Object> setter = new HashMap<Object, Object>();
        setter.put("name", GroovyPropertyUtils.getSetterName(name));
        setter.put("type", "void");
        setter.put("isStatic", isStatic);
        setter.put("doc", doc);
        setter.put("docUrl", docUrl);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(name, type);
        setter.put("params", param);
        this.method(setter);
    }

    public void constructor(Map<Object, Object> args) {
        if (args == null) {
            return;
        }
        args.put("constructor", true);
        this.method(args);
    }

    public ParameterDescriptor parameter(Map args) {
        return new ParameterDescriptor(args, (PsiElement)this.myDescriptor.justGetPlaceFile());
    }

    public void method(Map<Object, Object> args) {
        if (args == null) {
            return;
        }
        args = ContainerUtil.newLinkedHashMap(args);
        CustomMembersGenerator.parseMethod(args);
        args.put("declarationType", DeclarationType.METHOD);
        this.myDeclarations = this.myDeclarations.prepend((Object)args);
    }

    public void methodCall(Closure<Map<Object, Object>> generator) {
        PsiElement parent;
        PsiElement place = this.myDescriptor.getPlace();
        if (CustomMembersGenerator.isMethodCall(place, parent = place.getParent())) {
            assert (parent instanceof GrMethodCall && place instanceof GrReferenceExpression);
            GrReferenceExpression ref = (GrReferenceExpression)place;
            Object[] argTypes = PsiUtil.getArgumentTypes(ref, false);
            if (argTypes == null) {
                return;
            }
            Object[] types = new String[argTypes.length];
            ContainerUtil.map((Object[])argTypes, (Function)new Function<PsiType, Object>(){

                public Object fun(PsiType type) {
                    return type.getCanonicalText();
                }
            }, (Object[])types);
            generator.setDelegate((Object)this);
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("name", ref.getReferenceName());
            args.put("argumentTypes", types);
            generator.call(args);
        }
    }

    private static boolean isMethodCall(PsiElement place, PsiElement parent) {
        return place instanceof GrReferenceExpression && parent instanceof GrMethodCall && ((GrMethodCall)parent).getInvokedExpression() == place;
    }

    private static void parseMethod(Map args) {
        Object toThrow;
        Object params;
        String type = CustomMembersGenerator.stringifyType(args.get("type"));
        args.put("type", type);
        Object namedParams = args.get("namedParams");
        if (namedParams instanceof List) {
            LinkedHashMap newParams = new LinkedHashMap();
            newParams.put("args", namedParams);
            Object oldParams = args.get("params");
            if (oldParams instanceof Map) {
                newParams.putAll((Map)oldParams);
            }
            args.put("params", newParams);
        }
        if ((params = args.get("params")) instanceof Map) {
            boolean first = true;
            for (Map.Entry entry : ((Map)params).entrySet()) {
                Object value = entry.getValue();
                if (!first || !(value instanceof List)) {
                    entry.setValue(CustomMembersGenerator.stringifyType(value));
                }
                first = false;
            }
        }
        if ((toThrow = args.get(THROWS)) instanceof List) {
            ArrayList<String> list = new ArrayList<String>();
            for (Object o : (List)toThrow) {
                list.add(CustomMembersGenerator.stringifyType(o));
            }
            args.put(THROWS, list);
        } else if (toThrow != null) {
            args.put(THROWS, Collections.singletonList(CustomMembersGenerator.stringifyType(toThrow)));
        }
    }

    public void closureInMethod(Map<Object, Object> args) {
        if (args == null) {
            return;
        }
        args = ContainerUtil.newLinkedHashMap(args);
        CustomMembersGenerator.parseMethod(args);
        Object method = args.get("method");
        if (method instanceof Map) {
            CustomMembersGenerator.parseMethod((Map)method);
        }
        args.put("declarationType", DeclarationType.CLOSURE);
        this.myDeclarations = this.myDeclarations.prepend((Object)args);
    }

    public void variable(Map<Object, Object> args) {
        if (args == null) {
            return;
        }
        args = ContainerUtil.newLinkedHashMap(args);
        CustomMembersGenerator.parseVariable(args);
        this.myDeclarations = this.myDeclarations.prepend((Object)args);
    }

    private static void parseVariable(Map<Object, Object> args) {
        String type = CustomMembersGenerator.stringifyType(args.get("type"));
        args.put("type", type);
        args.put("declarationType", (Object)DeclarationType.VARIABLE);
    }

    private static String stringifyType(Object type) {
        if (type == null) {
            return "java.lang.Object";
        }
        if (type instanceof Closure) {
            return "groovy.lang.Closure";
        }
        if (type instanceof Map) {
            return "java.util.Map";
        }
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        String s = type.toString();
        LOG.assertTrue(!s.startsWith("? extends"), (Object)s);
        LOG.assertTrue(!s.contains("?extends"), (Object)s);
        LOG.assertTrue(!s.contains("<null."), (Object)s);
        LOG.assertTrue(!s.startsWith("null."), (Object)s);
        LOG.assertTrue(!s.contains(",") || s.contains("<"), (Object)s);
        return s;
    }

    @Nullable
    public Object methodMissing(String name, Object args) {
        Object[] newArgs = this.constructNewArgs((Object[])args);
        for (GdslMembersProvider provider : PROVIDERS) {
            List variants = DefaultGroovyMethods.getMetaClass((Object)provider).respondsTo((Object)provider, name, newArgs);
            if (variants.size() != 1) continue;
            return InvokerHelper.invokeMethod((Object)provider, (String)name, (Object)newArgs);
        }
        return null;
    }

    @Nullable
    public Object propertyMissing(String name) {
        List list;
        if (this.myBindings != null && (list = this.myBindings.get(name)) != null) {
            return list;
        }
        return null;
    }

    public static class GdslNamedParameter
    extends FakePsiElement {
        private final String myName;
        public final String docString;
        private final PsiElement myParent;
        @Nullable
        public final String myParameterTypeText;

        public GdslNamedParameter(String name, String doc, @NotNull PsiElement parent, @Nullable String type) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/dsl/CustomMembersGenerator$GdslNamedParameter", "<init>"));
            }
            this.myName = name;
            this.docString = doc;
            this.myParent = parent;
            this.myParameterTypeText = type;
        }

        public PsiElement getParent() {
            return this.myParent;
        }

        public String getName() {
            return this.myName;
        }
    }

    public static class ParameterDescriptor {
        public final String name;
        public final NamedArgumentDescriptor descriptor;

        private ParameterDescriptor(Map args, PsiElement context) {
            this.name = (String)args.get("name");
            final String typeText = CustomMembersGenerator.stringifyType(args.get("type"));
            Object doc = args.get("doc");
            this.descriptor = new NamedArgumentDescriptor((PsiElement)new GdslNamedParameter(this.name, doc instanceof String ? (String)doc : null, context, typeText)){

                @Override
                public boolean checkType(@NotNull PsiType type, @NotNull GroovyPsiElement context) {
                    if (type == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/dsl/CustomMembersGenerator$ParameterDescriptor$1", "checkType"));
                    }
                    if (context == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/dsl/CustomMembersGenerator$ParameterDescriptor$1", "checkType"));
                    }
                    return typeText == null || ClassContextFilter.isSubtype(type, context.getContainingFile(), typeText);
                }
            };
            this.descriptor.setPriority(NamedArgumentDescriptor.Priority.ALWAYS_ON_TOP);
        }
    }
}

