/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.doc.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.codehaus.groovy.ant.Groovydoc;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.groovy.doc.GenerateGroovyDocDialog;
import org.jetbrains.plugins.groovy.doc.GroovyDocBundle;
import org.jetbrains.plugins.groovy.doc.GroovyDocConfiguration;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public final class GenerateGroovyDocAction
extends AnAction
implements DumbAware {
    @NonNls
    private static final String INDEX_HTML = "index.html";

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        com.intellij.openapi.project.Project project = (com.intellij.openapi.project.Project)CommonDataKeys.PROJECT.getData(dataContext);
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        if (module == null) {
            return;
        }
        GroovyDocConfiguration configuration = new GroovyDocConfiguration();
        VirtualFile[] files = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (files.length == 1) {
            configuration.INPUT_DIRECTORY = files[0].getPath();
        }
        GenerateGroovyDocDialog dialog = new GenerateGroovyDocDialog(project, configuration);
        dialog.show();
        if (!dialog.isOK()) {
            return;
        }
        GenerateGroovyDocAction.generateGroovydoc(configuration, project);
    }

    public void update(AnActionEvent event) {
        super.update(event);
        Presentation presentation = event.getPresentation();
        Module module = (Module)LangDataKeys.MODULE.getData(event.getDataContext());
        if (module == null || !LibrariesUtil.hasGroovySdk(module)) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
        } else {
            presentation.setEnabled(true);
            presentation.setVisible(true);
        }
    }

    private static void generateGroovydoc(final GroovyDocConfiguration configuration, com.intellij.openapi.project.Project project) {
        File url;
        Runnable groovyDocRun = new Runnable(){

            @Override
            public void run() {
                Groovydoc groovydoc = new Groovydoc();
                groovydoc.setProject(new Project());
                groovydoc.setDestdir(new File(configuration.OUTPUT_DIRECTORY));
                groovydoc.setPrivate(configuration.OPTION_IS_PRIVATE);
                groovydoc.setUse(configuration.OPTION_IS_USE);
                groovydoc.setWindowtitle(configuration.WINDOW_TITLE);
                Path path = new Path(new Project());
                path.setPath(configuration.INPUT_DIRECTORY);
                groovydoc.setSourcepath(path);
                String packages = "";
                for (int i = 0; i < configuration.PACKAGES.length; ++i) {
                    String s = configuration.PACKAGES[i];
                    if (s != null && s.isEmpty()) continue;
                    if (i > 0) {
                        packages = packages + ",";
                    }
                    packages = packages + s;
                }
                groovydoc.setPackagenames(packages);
                ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                progressIndicator.setIndeterminate(true);
                progressIndicator.setText(GroovyDocBundle.message("groovy.doc.progress.indication.text", new Object[0]));
                groovydoc.execute();
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(groovyDocRun, GroovyDocBundle.message("groovy.documentation.generating", new Object[0]), false, project);
        if (configuration.OPEN_IN_BROWSER && (url = new File(configuration.OUTPUT_DIRECTORY, INDEX_HTML)).exists()) {
            BrowserUtil.browse((File)url);
        }
    }
}

