/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.doc;

import com.intellij.CommonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.doc.GroovyDocBundle;
import org.jetbrains.plugins.groovy.doc.GroovyDocConfiguration;
import org.jetbrains.plugins.groovy.doc.GroovyDocGenerationPanel;

public final class GenerateGroovyDocDialog
extends DialogWrapper {
    private final Project myProject;
    private final GroovyDocConfiguration myConfiguration;
    private GroovyDocGenerationPanel myPanel;

    public GenerateGroovyDocDialog(Project project, GroovyDocConfiguration configuration) {
        super(project, true);
        this.myProject = project;
        this.myConfiguration = configuration;
        this.setOKButtonText(GroovyDocBundle.message("groovydoc.generate.start.button", new Object[0]));
        this.setTitle(GroovyDocBundle.message("groovydoc.generate.title", new Object[0]));
        this.init();
    }

    protected JComponent createCenterPanel() {
        this.myPanel = new GroovyDocGenerationPanel();
        this.myPanel.reset(this.myConfiguration);
        return this.myPanel.getPanel();
    }

    protected void doOKAction() {
        this.myPanel.apply(this.myConfiguration);
        if (this.checkDir(this.myConfiguration.OUTPUT_DIRECTORY, "output") && this.checkDir(this.myConfiguration.INPUT_DIRECTORY, "input")) {
            this.close(0);
        }
    }

    @Nullable
    protected String getHelpId() {
        return "editing.groovydocGeneration";
    }

    private boolean checkDir(String dirName, String dirPrefix) {
        if (dirName == null || dirName.trim().length() == 0) {
            Messages.showMessageDialog((Project)this.myProject, (String)GroovyDocBundle.message("groovydoc.generate.0.directory.not.specified", dirPrefix), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            return false;
        }
        File dir = new File(dirName);
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                this.showError(GroovyDocBundle.message("groovydoc.generate.not.a.directory", dirName));
                return false;
            }
        } else {
            int choice = Messages.showOkCancelDialog((Project)this.myProject, (String)GroovyDocBundle.message("groovydoc.generate.directory.not.exists", dirName), (String)GroovyDocBundle.message("groovydoc.generate.message.title", new Object[0]), (Icon)Messages.getWarningIcon());
            if (choice != 0) {
                return false;
            }
            if (!dir.mkdirs()) {
                this.showError(GroovyDocBundle.message("groovydoc.generate.directory.creation.failed", dirName));
                return false;
            }
        }
        return true;
    }

    private void showError(String message) {
        Messages.showMessageDialog((Project)this.myProject, (String)message, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
    }
}

