/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.dgm;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dgm.GdkMethodHolder;
import org.jetbrains.plugins.groovy.dgm.GroovyExtensionProvider;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;

public class DGMMemberContributor
extends NonCodeMembersContributor {
    @Override
    public void processDynamicElements(@NotNull PsiType qualifierType, PsiClass aClass, PsiScopeProcessor processor, PsiElement place, ResolveState state) {
        if (qualifierType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/dgm/DGMMemberContributor", "processDynamicElements"));
        }
        Project project = place.getProject();
        GlobalSearchScope resolveScope = place.getResolveScope();
        GroovyPsiManager groovyPsiManager = GroovyPsiManager.getInstance(project);
        Pair<List<String>, List<String>> extensions = GroovyExtensionProvider.getInstance(project).collectExtensions(resolveScope);
        List instanceCategories = (List)extensions.getFirst();
        List staticCategories = (List)extensions.getSecond();
        if (!DGMMemberContributor.processCategories(qualifierType, processor, state, project, resolveScope, groovyPsiManager, instanceCategories, false)) {
            return;
        }
        if (!DGMMemberContributor.processCategories(qualifierType, processor, state, project, resolveScope, groovyPsiManager, staticCategories, true)) {
            return;
        }
    }

    private static boolean processCategories(PsiType qualifierType, PsiScopeProcessor processor, ResolveState state, Project project, GlobalSearchScope resolveScope, GroovyPsiManager groovyPsiManager, List<String> instanceCategories, boolean isStatic) {
        for (String category : instanceCategories) {
            PsiClass clazz = groovyPsiManager.findClassWithCache(category, resolveScope);
            if (clazz == null || GdkMethodHolder.getHolderForClass(clazz, isStatic, resolveScope).processMethods(processor, state, qualifierType, project)) continue;
            return false;
        }
        return true;
    }
}

