/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.debugger.filters;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.debugger.filters.GroovyDebuggerSettings;

public class GroovyDebuggerSettingsConfigurable
implements SearchableConfigurable {
    private JCheckBox myIgnoreGroovyMethods;
    private JPanel myPanel;
    private JCheckBox myEnableHotSwap;
    private boolean isModified = false;
    private final GroovyDebuggerSettings mySettings;

    public GroovyDebuggerSettingsConfigurable(GroovyDebuggerSettings settings) {
        this.mySettings = settings;
        Boolean flag = settings.DEBUG_DISABLE_SPECIFIC_GROOVY_METHODS;
        this.$$$setupUI$$$();
        this.myIgnoreGroovyMethods.setSelected(flag == null || flag != false);
        this.myIgnoreGroovyMethods.setSelected(this.mySettings.ENABLE_GROOVY_HOTSWAP);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroovyDebuggerSettingsConfigurable.this.isModified = ((GroovyDebuggerSettingsConfigurable)GroovyDebuggerSettingsConfigurable.this).mySettings.DEBUG_DISABLE_SPECIFIC_GROOVY_METHODS.booleanValue() != GroovyDebuggerSettingsConfigurable.this.myIgnoreGroovyMethods.isSelected() || ((GroovyDebuggerSettingsConfigurable)GroovyDebuggerSettingsConfigurable.this).mySettings.ENABLE_GROOVY_HOTSWAP != GroovyDebuggerSettingsConfigurable.this.myEnableHotSwap.isSelected();
            }
        };
        this.myIgnoreGroovyMethods.addActionListener(listener);
        this.myEnableHotSwap.addActionListener(listener);
    }

    @Nls
    public String getDisplayName() {
        return GroovyBundle.message("groovy.debug.caption", new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.idesettings.debugger.groovy";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/debugger/filters/GroovyDebuggerSettingsConfigurable", "getId"));
        }
        return string;
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void apply() throws ConfigurationException {
        if (this.isModified) {
            this.mySettings.DEBUG_DISABLE_SPECIFIC_GROOVY_METHODS = this.myIgnoreGroovyMethods.isSelected();
            this.mySettings.ENABLE_GROOVY_HOTSWAP = this.myEnableHotSwap.isSelected();
        }
        this.isModified = false;
    }

    public void reset() {
        Boolean flag = this.mySettings.DEBUG_DISABLE_SPECIFIC_GROOVY_METHODS;
        this.myIgnoreGroovyMethods.setSelected(flag == null || flag != false);
        this.myEnableHotSwap.setSelected(this.mySettings.ENABLE_GROOVY_HOTSWAP);
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myIgnoreGroovyMethods = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("org/jetbrains/plugins/groovy/GroovyBundle").getString("groovy.debug.disable.specific.methods"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setText("May cause serialization issues in the debugged application");
        jPanel.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(2, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myEnableHotSwap = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable hot-swap agent for Groovy code");
        jCheckBox.setMnemonic('H');
        jCheckBox.setDisplayedMnemonicIndex(7);
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

