/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GroovyShellRunner {
    private static final ExtensionPointName<GroovyShellRunner> EP_NAME = ExtensionPointName.create((String)"org.intellij.groovy.groovyShellRunner");

    @NotNull
    public abstract String getWorkingDirectory(@NotNull Module var1);

    @NotNull
    public abstract JavaParameters createJavaParameters(@NotNull Module var1) throws ExecutionException;

    public abstract boolean canRun(@NotNull Module var1);

    @NotNull
    public String getTitle(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/console/GroovyShellRunner", "getTitle"));
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyShellRunner", "getTitle"));
        }
        return "";
    }

    @Nullable
    public PsiElement getContext(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/console/GroovyShellRunner", "getContext"));
        }
        return null;
    }

    @NotNull
    public String transformUserInput(@NotNull String userInput) {
        if (userInput == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/console/GroovyShellRunner", "transformUserInput"));
        }
        String string = userInput;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/console/GroovyShellRunner", "transformUserInput"));
        }
        return string;
    }

    @Nullable
    public static GroovyShellRunner getAppropriateRunner(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/console/GroovyShellRunner", "getAppropriateRunner"));
        }
        for (GroovyShellRunner runner : (GroovyShellRunner[])EP_NAME.getExtensions()) {
            if (!runner.canRun(module)) continue;
            return runner;
        }
        return null;
    }
}

