/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler.generator;

import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.FileSetCompileScope;
import com.intellij.compiler.impl.TranslatingCompilerFilesMonitor;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.compiler.options.ExcludedEntriesConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Chunk;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerBase;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfiguration;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.refactoring.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.refactoring.convertToJava.GroovyToJavaGenerator;

public class GroovycStubGenerator
extends GroovyCompilerBase {
    private static Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.compiler.generator.GroovycStubGenerator");
    public static final String GROOVY_STUBS = "groovyStubs";

    public GroovycStubGenerator(Project project) {
        super(project);
    }

    @Override
    public void compile(CompileContext compileContext, Chunk<Module> moduleChunk, VirtualFile[] virtualFiles, TranslatingCompiler.OutputSink sink) {
        ExcludedEntriesConfiguration excluded = GroovyCompilerConfiguration.getExcludeConfiguration(this.myProject);
        FactoryMap<Pair<Module, Boolean>, Boolean> hasJava = new FactoryMap<Pair<Module, Boolean>, Boolean>(){

            protected Boolean create(Pair<Module, Boolean> key) {
                return GroovycStubGenerator.containsJavaSources((Module)key.first, (Boolean)key.second);
            }
        };
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        ArrayList<VirtualFile> total = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : virtualFiles) {
            Module module;
            if (excluded.isExcluded(virtualFile) || !GroovyNamesUtil.isIdentifier(virtualFile.getNameWithoutExtension()) || (module = index.getModuleForFile(virtualFile)) != null && !((Boolean)hasJava.get((Object)Pair.create((Object)module, (Object)index.isInTestSourceContent(virtualFile)))).booleanValue()) continue;
            total.add(virtualFile);
        }
        if (total.isEmpty()) {
            return;
        }
        super.compile(compileContext, moduleChunk, VfsUtil.toVirtualFileArray(total), sink);
    }

    private static boolean containsJavaSources(Module module, boolean inTests) {
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
        List roots = inTests ? rootManager.getSourceRoots((JpsModuleSourceRootType)JavaSourceRootType.TEST_SOURCE) : rootManager.getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
        for (VirtualFile dir : roots) {
            if (rootManager.getFileIndex().iterateContentUnderDirectory(dir, new ContentIterator(){

                public boolean processFile(VirtualFile fileOrDir) {
                    return fileOrDir.isDirectory() || JavaFileType.INSTANCE != fileOrDir.getFileType();
                }
            })) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void compileFiles(CompileContext compileContext, Module module, List<VirtualFile> toCompile, TranslatingCompiler.OutputSink sink, boolean tests) {
        File outDir = GroovycStubGenerator.getStubOutput(module, tests);
        outDir.mkdirs();
        VirtualFile tempOutput = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(outDir);
        assert (tempOutput != null);
        this.cleanDirectory(tempOutput);
        ((CompileContextEx)compileContext).assignModule(tempOutput, module, tests, (Compiler)this);
        ProgressIndicator indicator = compileContext.getProgressIndicator();
        indicator.pushState();
        try {
            GroovyToJavaGenerator generator = new GroovyToJavaGenerator(this.myProject, new HashSet<VirtualFile>(toCompile));
            for (int i = 0; i < toCompile.size(); ++i) {
                indicator.setFraction((double)i / (double)toCompile.size());
                Collection<VirtualFile> stubFiles = GroovycStubGenerator.generateItems(generator, toCompile.get(i), tempOutput, compileContext, this.myProject);
                ((CompileContextEx)compileContext).addScope((CompileScope)new FileSetCompileScope(stubFiles, new Module[]{module}));
            }
        }
        finally {
            indicator.popState();
        }
    }

    private static File getStubOutput(Module module, boolean tests) {
        Project project = module.getProject();
        String rootPath = CompilerPaths.getGeneratedDataDirectory((Project)project).getPath() + "/" + GROOVY_STUBS + "/";
        return new File(rootPath + module.getName() + "/" + (tests ? "tests" : "production") + "/");
    }

    @Nullable
    public static PsiClass findClassByStub(Project project, VirtualFile stubFile) {
        String[] components = StringUtil.trimEnd((String)stubFile.getPath(), (String)".java").split("[\\\\/]");
        int stubs = Arrays.asList(components).indexOf(GROOVY_STUBS);
        if (stubs < 0 || stubs >= components.length - 3) {
            return null;
        }
        String moduleName = components[stubs + 1];
        Module module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
        if (module == null) {
            return null;
        }
        String fqn = StringUtil.join(Arrays.asList(components).subList(stubs + 3, components.length), (String)".");
        return JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.moduleScope((Module)module));
    }

    private void cleanDirectory(final VirtualFile dir) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AccessToken token = WriteAction.start();
                try {
                    VfsUtil.processFilesRecursively((VirtualFile)dir, (Processor)new Processor<VirtualFile>(){

                        public boolean process(VirtualFile virtualFile) {
                            if (!virtualFile.isDirectory()) {
                                TranslatingCompilerFilesMonitor.removeSourceInfo((VirtualFile)virtualFile);
                                try {
                                    virtualFile.delete((Object)this);
                                }
                                catch (IOException e) {
                                    LOG.info((Throwable)e);
                                }
                            }
                            return true;
                        }
                    });
                }
                finally {
                    token.finish();
                }
            }
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            assert (ApplicationManager.getApplication().isUnitTestMode());
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeAndWait(runnable, ModalityState.NON_MODAL);
        }
    }

    @NotNull
    public String getDescription() {
        if ("Groovy to java source code generator" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/compiler/generator/GroovycStubGenerator", "getDescription"));
        }
        return "Groovy to java source code generator";
    }

    public boolean validateConfiguration(CompileScope scope) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<VirtualFile> generateItems(GroovyToJavaGenerator generator, VirtualFile item, VirtualFile outputRootDirectory, CompileContext context, Project project) {
        Map<String, CharSequence> output;
        ProgressIndicator indicator = context.getProgressIndicator();
        indicator.setText("Generating stubs for " + item.getName() + "...");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Generating stubs for " + item.getName() + "...");
        }
        AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
        try {
            output = generator.generateStubs((GroovyFile)PsiManager.getInstance((Project)project).findFile(item));
        }
        finally {
            accessToken.finish();
        }
        return GroovycStubGenerator.writeStubs(outputRootDirectory, output, item);
    }

    private static List<VirtualFile> writeStubs(VirtualFile outputRootDirectory, Map<String, CharSequence> output, VirtualFile src) {
        ArrayList stubs = ContainerUtil.newArrayList();
        for (String relativePath : output.keySet()) {
            File stubFile = new File(outputRootDirectory.getPath(), relativePath);
            FileUtil.createIfDoesntExist((File)stubFile);
            try {
                FileUtil.writeToFile((File)stubFile, (byte[])((Object)output.get(relativePath)).toString().getBytes(src.getCharset()));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            CompilerUtil.refreshIOFile((File)stubFile);
            ContainerUtil.addIfNotNull((Object)LocalFileSystem.getInstance().refreshAndFindFileByIoFile(stubFile), (Collection)stubs);
        }
        return stubs;
    }
}

