/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.ui.EditorNotificationPanel;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.compiler.ExcludeFromStubGenerationAction;
import org.jetbrains.plugins.groovy.compiler.GroovyCompiler;
import org.jetbrains.plugins.groovy.compiler.generator.GroovycStubGenerator;

public class GroovyCompilerLoader
extends AbstractProjectComponent {
    public GroovyCompilerLoader(Project project) {
        super(project);
    }

    public void projectOpened() {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        compilerManager.addCompilableFileType((FileType)GroovyFileType.GROOVY_FILE_TYPE);
        compilerManager.addTranslatingCompiler((TranslatingCompiler)new GroovycStubGenerator(this.myProject), new HashSet<LanguageFileType>(Arrays.asList(new LanguageFileType[]{StdFileTypes.JAVA, GroovyFileType.GROOVY_FILE_TYPE})), new HashSet<LanguageFileType>(Arrays.asList(StdFileTypes.JAVA)));
        compilerManager.addTranslatingCompiler((TranslatingCompiler)new GroovyCompiler(this.myProject), new HashSet<FileType>(Arrays.asList(new FileType[]{GroovyFileType.GROOVY_FILE_TYPE, StdFileTypes.CLASS})), new HashSet<FileType>(Arrays.asList(StdFileTypes.CLASS)));
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                FileEditorManager fileEditorManager;
                FileEditor[] editors;
                PsiClass psiClass;
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/compiler/GroovyCompilerLoader$1", "fileOpened"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/compiler/GroovyCompilerLoader$1", "fileOpened"));
                }
                if (file.getName().endsWith(".java") && file.getPath().contains("groovyStubs") && (psiClass = GroovycStubGenerator.findClassByStub(GroovyCompilerLoader.this.myProject, file)) != null && (editors = (fileEditorManager = FileEditorManager.getInstance((Project)GroovyCompilerLoader.this.myProject)).getEditors(file)).length != 0) {
                    GroovyCompilerLoader.this.decorateStubFile(file, fileEditorManager, editors[0]);
                }
            }
        });
    }

    private void decorateStubFile(final VirtualFile file, FileEditorManager fileEditorManager, FileEditor editor) {
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText("This stub is generated for Groovy class to make Groovy-Java cross-compilation possible");
        panel.createActionLabel("Go to the Groovy class", new Runnable(){

            @Override
            public void run() {
                PsiClass original = GroovycStubGenerator.findClassByStub(GroovyCompilerLoader.this.myProject, file);
                if (original != null) {
                    original.navigate(true);
                }
            }
        });
        panel.createActionLabel("Exclude from stub generation", new Runnable(){

            @Override
            public void run() {
                PsiClass psiClass = GroovycStubGenerator.findClassByStub(GroovyCompilerLoader.this.myProject, file);
                if (psiClass != null) {
                    ExcludeFromStubGenerationAction.doExcludeFromStubGeneration(psiClass.getContainingFile());
                }
            }
        });
        fileEditorManager.addTopComponent(editor, (JComponent)panel);
    }

    @NotNull
    public String getComponentName() {
        if ("GroovyCompilerLoader" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/compiler/GroovyCompilerLoader", "getComponentName"));
        }
        return "GroovyCompilerLoader";
    }
}

