/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import icons.JetgroovyIcons;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.GroovyFileTypeLoader;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerBase;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfiguration;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.util.GroovyUtils;
import org.jetbrains.plugins.groovy.util.LibrariesUtil;

public class GroovyCompiler
extends GroovyCompilerBase {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.compiler.GroovyCompiler");
    private static final String AST_TRANSFORM_FILE_NAME = "org.codehaus.groovy.transform.ASTTransformation";

    public GroovyCompiler(Project project) {
        super(project);
    }

    @NotNull
    public String getDescription() {
        if ("groovy compiler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/compiler/GroovyCompiler", "getDescription"));
        }
        return "groovy compiler";
    }

    @Override
    protected void compileFiles(CompileContext context, Module module, List<VirtualFile> toCompile, TranslatingCompiler.OutputSink sink, boolean tests) {
        context.getProgressIndicator().checkCanceled();
        context.getProgressIndicator().setText("Starting Groovy compiler...");
        this.runGroovycCompiler(context, module, toCompile, false, GroovyCompiler.getMainOutput(context, module, tests), sink, tests);
    }

    public boolean validateConfiguration(CompileScope compileScope) {
        VirtualFile[] files = compileScope.getFiles((FileType)GroovyFileType.GROOVY_FILE_TYPE, true);
        if (files.length == 0) {
            return true;
        }
        Set<String> scriptExtensions = GroovyFileTypeLoader.getCustomGroovyScriptExtensions();
        CompilerManager compilerManager = CompilerManager.getInstance((Project)this.myProject);
        HashSet<Module> modules = new HashSet<Module>();
        for (VirtualFile file : files) {
            ProjectRootManager rootManager;
            Module module;
            if (scriptExtensions.contains(file.getExtension()) || compilerManager.isExcludedFromCompilation(file) || CompilerConfiguration.getInstance((Project)this.myProject).isResourceFile(file) || (module = (rootManager = ProjectRootManager.getInstance((Project)this.myProject)).getFileIndex().getModuleForFile(file)) == null) continue;
            modules.add(module);
        }
        HashSet<Module> nojdkModules = new HashSet<Module>();
        for (Module module : modules) {
            if (!GroovyUtils.isAcceptableModuleType(ModuleType.get((Module)module))) continue;
            Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
            if (sdk == null || !(sdk.getSdkType() instanceof JavaSdkType)) {
                nojdkModules.add(module);
                continue;
            }
            if (LibrariesUtil.hasGroovySdk(module) || GroovyConfigUtils.getInstance().tryToSetUpGroovyFacetOnTheFly(module)) continue;
            Messages.showErrorDialog((Project)this.myProject, (String)GroovyBundle.message("cannot.compile.groovy.files.no.facet", module.getName()), (String)GroovyBundle.message("cannot.compile", new Object[0]));
            ModulesConfigurator.showDialog((Project)module.getProject(), (String)module.getName(), (String)ClasspathEditor.NAME);
            return false;
        }
        if (!nojdkModules.isEmpty()) {
            Module[] noJdkArray = nojdkModules.toArray(new Module[nojdkModules.size()]);
            if (noJdkArray.length == 1) {
                Messages.showErrorDialog((Project)this.myProject, (String)GroovyBundle.message("cannot.compile.groovy.files.no.sdk", noJdkArray[0].getName()), (String)GroovyBundle.message("cannot.compile", new Object[0]));
            } else {
                StringBuilder modulesList = new StringBuilder();
                for (int i = 0; i < noJdkArray.length; ++i) {
                    if (i > 0) {
                        modulesList.append(", ");
                    }
                    modulesList.append(noJdkArray[i].getName());
                }
                Messages.showErrorDialog((Project)this.myProject, (String)GroovyBundle.message("cannot.compile.groovy.files.no.sdk.mult", modulesList.toString()), (String)GroovyBundle.message("cannot.compile", new Object[0]));
            }
            return false;
        }
        GroovyCompilerConfiguration configuration = GroovyCompilerConfiguration.getInstance(this.myProject);
        if (!configuration.transformsOk && this.needTransformCopying(compileScope)) {
            int result = Messages.showYesNoDialog((Project)this.myProject, (String)"You seem to have global Groovy AST transformations defined in your project,\nbut they won't be applied to your code because they are not marked as compiler resources.\nDo you want to add them to compiler resource list?\n(you can do it yourself later in Settings | Compiler | Resource patterns)", (String)"AST Transformations Found", (Icon)JetgroovyIcons.Groovy.Groovy_32x32);
            if (result == 0) {
                CompilerConfiguration.getInstance((Project)this.myProject).addResourceFilePattern(AST_TRANSFORM_FILE_NAME);
            } else {
                configuration.transformsOk = true;
            }
        }
        return true;
    }

    private boolean needTransformCopying(CompileScope compileScope) {
        CompilerConfiguration configuration = CompilerConfiguration.getInstance((Project)this.myProject);
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        for (VirtualFile file : FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)AST_TRANSFORM_FILE_NAME, (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject))) {
            if (!compileScope.belongs(file.getUrl()) || !index.isInSource(file) || configuration.isResourceFile(file)) continue;
            return true;
        }
        return false;
    }
}

