/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfigurable;
import org.jetbrains.plugins.groovy.compiler.GroovyCompilerConfiguration;

public class ExcludeFromStubGenerationAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        PsiFile file = (PsiFile)e.getData(DataKeys.PSI_FILE);
        assert (file != null && file.getLanguage() == GroovyFileType.GROOVY_LANGUAGE);
        ExcludeFromStubGenerationAction.doExcludeFromStubGeneration(file);
    }

    public static void doExcludeFromStubGeneration(PsiFile file) {
        final VirtualFile virtualFile = file.getVirtualFile();
        assert (virtualFile != null);
        final Project project = file.getProject();
        final GroovyCompilerConfigurable configurable = new GroovyCompilerConfigurable(project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, new Runnable(){

            @Override
            public void run() {
                configurable.getExcludes().addEntry(new ExcludeEntryDescription(virtualFile, false, true, (Disposable)project));
            }
        });
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        boolean enabled = ExcludeFromStubGenerationAction.isEnabled(e);
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
    }

    private static boolean isEnabled(AnActionEvent e) {
        PsiFile file = (PsiFile)e.getData(DataKeys.PSI_FILE);
        if (file == null || file.getLanguage() != GroovyFileType.GROOVY_LANGUAGE) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile != null && !GroovyCompilerConfiguration.getExcludeConfiguration(file.getProject()).isExcluded(virtualFile);
    }
}

