/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.ReferenceAdjuster;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.debugger.fragments.GroovyCodeFragment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReferenceElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrReferenceAdjuster
implements ReferenceAdjuster {
    public static boolean seemsToBeQualifiedClassName(@Nullable GrExpression expr) {
        if (expr == null) {
            return false;
        }
        while (expr instanceof GrReferenceExpression) {
            PsiElement nameElement = ((GrReferenceExpression)expr).getReferenceNameElement();
            if (((GrReferenceExpression)expr).getTypeArguments().length > 0) {
                return false;
            }
            if (nameElement == null || nameElement.getNode().getElementType() != GroovyTokenTypes.mIDENT) {
                return false;
            }
            IElementType dotType = ((GrReferenceExpression)expr).getDotTokenType();
            if (dotType != null && dotType != GroovyTokenTypes.mDOT) {
                return false;
            }
            expr = ((GrReferenceExpression)expr).getQualifierExpression();
        }
        return expr == null;
    }

    public ASTNode process(@NotNull ASTNode element, boolean addImports, boolean incompleteCode, boolean useFqInJavadoc, boolean useFqInCode) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeStyle/GrReferenceAdjuster", "process"));
        }
        TextRange range = element.getTextRange();
        GrReferenceAdjuster.process(element.getPsi(), range.getStartOffset(), range.getEndOffset(), addImports, incompleteCode, useFqInJavadoc, useFqInCode);
        return element;
    }

    public ASTNode process(@NotNull ASTNode element, boolean addImports, boolean incompleteCode, Project project) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeStyle/GrReferenceAdjuster", "process"));
        }
        GroovyCodeStyleSettings settings = (GroovyCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(GroovyCodeStyleSettings.class);
        return this.process(element, addImports, incompleteCode, settings.USE_FQ_CLASS_NAMES_IN_JAVADOC, settings.USE_FQ_CLASS_NAMES);
    }

    public void processRange(@NotNull ASTNode element, int startOffset, int endOffset, boolean useFqInJavadoc, boolean useFqInCode) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeStyle/GrReferenceAdjuster", "processRange"));
        }
        GrReferenceAdjuster.process(element.getPsi(), startOffset, endOffset, true, true, useFqInJavadoc, useFqInCode);
    }

    public void processRange(@NotNull ASTNode element, int startOffset, int endOffset, Project project) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeStyle/GrReferenceAdjuster", "processRange"));
        }
        GroovyCodeStyleSettings settings = (GroovyCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(GroovyCodeStyleSettings.class);
        this.processRange(element, startOffset, endOffset, settings.USE_FQ_CLASS_NAMES_IN_JAVADOC, settings.USE_FQ_CLASS_NAMES);
    }

    private static boolean process(@NotNull PsiElement element, int start, int end, boolean addImports, boolean incomplete, boolean useFqInJavadoc, boolean useFqInCode) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeStyle/GrReferenceAdjuster", "process"));
        }
        boolean result = false;
        if (element instanceof GrQualifiedReference && ((GrQualifiedReference)element).resolve() instanceof PsiClass) {
            result = GrReferenceAdjuster.shortenReferenceInner((GrQualifiedReference)element, addImports, incomplete, useFqInJavadoc, useFqInCode);
        } else if (element instanceof GrReferenceExpression && PsiUtil.isSuperReference(((GrReferenceExpression)element).getQualifier())) {
            result = GrReferenceAdjuster.shortenReferenceInner((GrReferenceExpression)element, addImports, incomplete, useFqInJavadoc, useFqInCode);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            TextRange range = child.getTextRange();
            if (start >= range.getEndOffset() || range.getStartOffset() >= end) continue;
            result |= GrReferenceAdjuster.process(child, start, end, addImports, incomplete, useFqInJavadoc, useFqInCode);
        }
        return result;
    }

    public static <T extends PsiElement> boolean shortenReference(@NotNull GrQualifiedReference<T> ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeStyle/GrReferenceAdjuster", "shortenReference"));
        }
        GroovyCodeStyleSettings settings = (GroovyCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)ref.getProject()).getCurrentSettings().getCustomSettings(GroovyCodeStyleSettings.class);
        boolean result = GrReferenceAdjuster.shortenReferenceInner(ref, true, false, settings.USE_FQ_CLASS_NAMES_IN_JAVADOC, settings.USE_FQ_CLASS_NAMES);
        TextRange range = ref.getTextRange();
        return result |= GrReferenceAdjuster.process(ref, range.getStartOffset(), range.getEndOffset(), true, false, settings.USE_FQ_CLASS_NAMES_IN_JAVADOC, settings.USE_FQ_CLASS_NAMES);
    }

    private static <Qualifier extends PsiElement> boolean shortenReferenceInner(@NotNull GrQualifiedReference<Qualifier> ref, boolean addImports, boolean incomplete, boolean useFqInJavadoc, boolean useFqInCode) {
        GrTypeArgumentList typeArgs;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeStyle/GrReferenceAdjuster", "shortenReferenceInner"));
        }
        Qualifier qualifier = ref.getQualifier();
        if (qualifier == null || PsiUtil.isSuperReference(qualifier) || GrReferenceAdjuster.cannotShortenInContext(ref)) {
            return false;
        }
        if (ref instanceof GrReferenceExpression && (typeArgs = ((GrReferenceExpression)ref).getTypeArgumentList()) != null && typeArgs.getTypeArgumentElements().length > 0) {
            return false;
        }
        if (!GrReferenceAdjuster.shorteningIsMeaningfully(ref, useFqInJavadoc, useFqInCode)) {
            return false;
        }
        PsiElement resolved = GrReferenceAdjuster.resolveRef(ref, incomplete);
        if (resolved == null) {
            return false;
        }
        if (!GrReferenceAdjuster.checkCopyWithoutQualifier(ref, addImports, resolved)) {
            return false;
        }
        ref.setQualifier(null);
        return true;
    }

    private static <Qualifier extends PsiElement> boolean checkCopyWithoutQualifier(@NotNull GrQualifiedReference<Qualifier> ref, boolean addImports, @NotNull PsiElement resolved) {
        PsiClass clazz;
        String qName;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeStyle/GrReferenceAdjuster", "checkCopyWithoutQualifier"));
        }
        if (resolved == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/codeStyle/GrReferenceAdjuster", "checkCopyWithoutQualifier"));
        }
        GrQualifiedReference<Qualifier> copy = GrReferenceAdjuster.getCopy(ref);
        if (copy == null) {
            return false;
        }
        copy.setQualifier(null);
        PsiElement resolvedCopy = copy.resolve();
        if (ref.getManager().areElementsEquivalent(resolved, resolvedCopy)) {
            return true;
        }
        if (resolvedCopy != null && !(resolvedCopy instanceof GrBindingVariable)) {
            return false;
        }
        if (resolved instanceof PsiClass && (qName = (clazz = (PsiClass)resolved).getQualifiedName()) != null && addImports && GrReferenceAdjuster.checkIsInnerClass(clazz, ref) && GrReferenceAdjuster.mayInsertImport(ref)) {
            GroovyFileBase file = (GroovyFileBase)ref.getContainingFile();
            GrImportStatement added = file.addImportForClass(clazz);
            if (copy.isReferenceTo(resolved)) {
                return true;
            }
            file.removeImport(added);
        }
        return false;
    }

    private static <Qualifier extends PsiElement> boolean checkIsInnerClass(@NotNull PsiClass resolved, GrQualifiedReference<Qualifier> ref) {
        if (resolved == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeStyle/GrReferenceAdjuster", "checkIsInnerClass"));
        }
        PsiClass containingClass = resolved.getContainingClass();
        return containingClass == null || PsiTreeUtil.isAncestor((PsiElement)containingClass, ref, (boolean)true) || ((GroovyCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)resolved.getProject()).getCustomSettings(GroovyCodeStyleSettings.class)).INSERT_INNER_CLASS_IMPORTS;
    }

    @Nullable
    private static <Qualifier extends PsiElement> PsiElement resolveRef(@NotNull GrQualifiedReference<Qualifier> ref, boolean incomplete) {
        String classNameText;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeStyle/GrReferenceAdjuster", "resolveRef"));
        }
        if (!incomplete) {
            return ref.resolve();
        }
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)ref.getProject()).getResolveHelper();
        if (ref instanceof GrReferenceElement && (classNameText = ((GrReferenceElement)ref).getClassNameText()) != null) {
            return helper.resolveReferencedClass(classNameText, ref);
        }
        return null;
    }

    @Nullable
    private static <Qualifier extends PsiElement> GrQualifiedReference<Qualifier> getCopy(@NotNull GrQualifiedReference<Qualifier> ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeStyle/GrReferenceAdjuster", "getCopy"));
        }
        if (ref.getParent() instanceof GrMethodCall) {
            GrMethodCall copy = (GrMethodCall)ref.getParent().copy();
            return (GrQualifiedReference)((Object)copy.getInvokedExpression());
        }
        return (GrQualifiedReference)ref.copy();
    }

    private static <Qualifier extends PsiElement> boolean shorteningIsMeaningfully(@NotNull GrQualifiedReference<Qualifier> ref, boolean useFqInJavadoc, boolean useFqInCode) {
        GrDocComment doc;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeStyle/GrReferenceAdjuster", "shorteningIsMeaningfully"));
        }
        if (ref instanceof GrReferenceElementImpl && ((GrReferenceElementImpl)ref).isFullyQualified() && ((doc = (GrDocComment)PsiTreeUtil.getParentOfType(ref, GrDocComment.class)) != null ? useFqInJavadoc : useFqInCode)) {
            return false;
        }
        Qualifier qualifier = ref.getQualifier();
        if (qualifier instanceof GrCodeReferenceElement) {
            return true;
        }
        if (qualifier instanceof GrExpression) {
            PsiElement resolved;
            if (qualifier instanceof GrReferenceExpression && PsiUtil.isThisReference(qualifier)) {
                return true;
            }
            if (qualifier instanceof GrReferenceExpression && GrReferenceAdjuster.seemsToBeQualifiedClassName((GrExpression)qualifier) && ((resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass || resolved instanceof PsiPackage)) {
                return true;
            }
        }
        return false;
    }

    private static <Qualifier extends PsiElement> boolean cannotShortenInContext(@NotNull GrQualifiedReference<Qualifier> ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeStyle/GrReferenceAdjuster", "cannotShortenInContext"));
        }
        return PsiTreeUtil.getParentOfType(ref, GrImportStatement.class) != null || PsiTreeUtil.getParentOfType(ref, GroovyCodeFragment.class) != null;
    }

    private static <Qualifier extends PsiElement> boolean mayInsertImport(@NotNull GrQualifiedReference<Qualifier> ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeStyle/GrReferenceAdjuster", "mayInsertImport"));
        }
        return !(ref.getContainingFile() instanceof GroovyCodeFragment) && PsiTreeUtil.getParentOfType(ref, GrImportStatement.class) == null && ref.getContainingFile() instanceof GroovyFileBase;
    }

    public static GrReferenceAdjuster getInstance() {
        return new GrReferenceAdjuster();
    }
}

