/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomDeclarationSearcher;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateClassFix;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateFieldFromUsageFix;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateGetterFromUsageFix;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateLocalVariableFromUsageFix;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateMethodFromUsageFix;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateParameterFromUsageFix;
import org.jetbrains.plugins.groovy.annotator.intentions.CreateSetterFromUsageFix;
import org.jetbrains.plugins.groovy.annotator.intentions.GroovyAddImportAction;
import org.jetbrains.plugins.groovy.annotator.intentions.GroovyStaticImportMethodFix;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicMethodFix;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicPropertyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.GroovySuppressableInspectionTool;
import org.jetbrains.plugins.groovy.extensions.GroovyUnresolvedHighlightFilter;
import org.jetbrains.plugins.groovy.findUsages.MissingMethodAndPropertyUtil;
import org.jetbrains.plugins.groovy.highlighter.DefaultHighlighter;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GroovyDocPsiElement;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrInterfaceDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrReferenceResolveUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.util.LightCacheKey;

public class GrUnresolvedAccessInspection
extends GroovySuppressableInspectionTool {
    private static final Logger LOG = Logger.getInstance(GrUnresolvedAccessInspection.class);
    private static final String SHORT_NAME = "GrUnresolvedAccess";
    public boolean myHighlightIfGroovyObjectOverridden = true;
    public boolean myHighlightIfMissingMethodsDeclared = true;
    public boolean myHighlightInnerClasses = true;
    private static final LightCacheKey<Map<String, Boolean>> GROOVY_OBJECT_METHODS_CACHE = new LightCacheKey<Map<String, Boolean>>(){

        @Override
        protected long getModificationCount(PsiElement holder) {
            return holder.getManager().getModificationTracker().getModificationCount();
        }
    };

    private static boolean shouldHighlightAsUnresolved(@NotNull GrReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessInspection", "shouldHighlightAsUnresolved"));
        }
        if (GrHighlightUtil.isDeclarationAssignment(referenceExpression)) {
            return false;
        }
        GrExpression qualifier = (GrExpression)referenceExpression.getQualifier();
        if (qualifier != null && qualifier.getType() == null && !GrUnresolvedAccessInspection.isRefToPackage(qualifier)) {
            return false;
        }
        if (qualifier != null && referenceExpression.getDotTokenType() == GroovyTokenTypes.mMEMBER_POINTER && referenceExpression.multiResolve(false).length > 0) {
            return false;
        }
        if (!GroovyUnresolvedHighlightFilter.shouldHighlight(referenceExpression)) {
            return false;
        }
        CollectConsumer consumer = new CollectConsumer();
        for (PomDeclarationSearcher searcher : (PomDeclarationSearcher[])PomDeclarationSearcher.EP_NAME.getExtensions()) {
            searcher.findDeclarationsAt((PsiElement)referenceExpression, 0, (Consumer)consumer);
            if (consumer.getResult().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static boolean isRefToPackage(GrExpression expr) {
        return expr instanceof GrReferenceExpression && ((GrReferenceExpression)expr).resolve() instanceof PsiPackage;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(GroovyInspectionBundle.message("highlight.if.groovy.object.methods.overridden", new Object[0]), "myHighlightIfGroovyObjectOverridden");
        optionsPanel.addCheckbox(GroovyInspectionBundle.message("highlight.if.missing.methods.declared", new Object[0]), "myHighlightIfMissingMethodsDeclared");
        optionsPanel.addCheckbox(GroovyBundle.message("highlight.constructor.calls.of.a.non.static.inner.classes.without.enclosing.instance.passed", new Object[0]), "myHighlightInnerClasses");
        return optionsPanel;
    }

    private static boolean isInspectionEnabled(PsiFile file, Project project) {
        InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)project).getInspectionProfile();
        HighlightDisplayKey unusedDefKey = HighlightDisplayKey.find((String)SHORT_NAME);
        return profile.isToolEnabled(unusedDefKey, (PsiElement)file);
    }

    public static GrUnresolvedAccessInspection getInstance(PsiFile file, Project project) {
        InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)project).getInspectionProfile();
        return (GrUnresolvedAccessInspection)profile.getUnwrappedTool(SHORT_NAME, (PsiElement)file);
    }

    private static HighlightDisplayLevel getHighlightDisplayLevel(Project project, GrReferenceElement ref) {
        InspectionProfile profile = InspectionProjectProfileManager.getInstance((Project)project).getInspectionProfile();
        return profile.getErrorLevel(HighlightDisplayKey.find((String)SHORT_NAME), (PsiElement)ref);
    }

    @Nullable
    public static HighlightInfo checkCodeReferenceElement(GrCodeReferenceElement refElement) {
        HighlightInfo info = GrUnresolvedAccessInspection.checkCodeRefInner(refElement);
        GrUnresolvedAccessInspection.addEmptyIntentionIfNeeded(info);
        return info;
    }

    @Nullable
    public static List<HighlightInfo> checkReferenceExpression(GrReferenceExpression ref) {
        List<HighlightInfo> info = GrUnresolvedAccessInspection.checkRefInner(ref);
        GrUnresolvedAccessInspection.addEmptyIntentionIfNeeded((HighlightInfo)ContainerUtil.getFirstItem(info));
        return info;
    }

    @Nullable
    private static HighlightInfo checkCodeRefInner(GrCodeReferenceElement refElement) {
        if (PsiTreeUtil.getParentOfType((PsiElement)refElement, GroovyDocPsiElement.class) != null) {
            return null;
        }
        PsiElement nameElement = refElement.getReferenceNameElement();
        if (nameElement == null) {
            return null;
        }
        if (GrUnresolvedAccessInspection.isResolvedStaticImport(refElement)) {
            return null;
        }
        GroovyResolveResult resolveResult = refElement.advancedResolve();
        PsiElement resolved = resolveResult.getElement();
        if (!(refElement.getParent() instanceof GrPackageDefinition) && resolved == null) {
            String message = GroovyBundle.message("cannot.resolve", refElement.getReferenceName());
            HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range(nameElement).descriptionAndTooltip(message).create();
            HighlightDisplayKey displayKey = HighlightDisplayKey.find((String)SHORT_NAME);
            GrUnresolvedAccessInspection.registerCreateClassByTypeFix(refElement, info, displayKey);
            GrUnresolvedAccessInspection.registerAddImportFixes(refElement, info, displayKey);
            UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)refElement, (QuickFixActionRegistrar)new QuickFixActionRegistrarAdapter(info, displayKey));
            OrderEntryFix.registerFixes((QuickFixActionRegistrar)new QuickFixActionRegistrarAdapter(info, displayKey), (PsiReference)refElement);
            return info;
        }
        if (refElement.getParent() instanceof GrNewExpression) {
            boolean inStaticContext = GrUnresolvedAccessInspection.isInStaticContext(refElement);
            if (!inStaticContext && GroovySuppressableInspectionTool.isElementToolSuppressedIn(refElement, SHORT_NAME)) {
                return null;
            }
            if (!inStaticContext) {
                if (!GrUnresolvedAccessInspection.isInspectionEnabled(refElement.getContainingFile(), refElement.getProject())) {
                    return null;
                }
                GrUnresolvedAccessInspection inspection = GrUnresolvedAccessInspection.getInstance(refElement.getContainingFile(), refElement.getProject());
                assert (inspection != null);
                if (!inspection.myHighlightInnerClasses) {
                    return null;
                }
            }
            GrNewExpression newExpression = (GrNewExpression)refElement.getParent();
            if (resolved instanceof PsiClass) {
                PsiClass clazz = (PsiClass)resolved;
                if (newExpression.getQualifier() == null) {
                    PsiClass outerClass = clazz.getContainingClass();
                    if (com.intellij.psi.util.PsiUtil.isInnerClass((PsiClass)clazz) && outerClass != null && newExpression.getArgumentList() != null && !PsiUtil.hasEnclosingInstanceInScope(outerClass, newExpression, true) && !GrUnresolvedAccessInspection.hasEnclosingInstanceInArgList(newExpression.getArgumentList(), outerClass)) {
                        String qname = clazz.getQualifiedName();
                        LOG.assertTrue(qname != null, (Object)clazz.getText());
                        return GrUnresolvedAccessInspection.createAnnotationForRef(refElement, inStaticContext, GroovyBundle.message("cannot.reference.non.static", qname));
                    }
                }
            }
        }
        return null;
    }

    private static boolean hasEnclosingInstanceInArgList(@NotNull GrArgumentList list, @NotNull PsiClass enclosingClass) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessInspection", "hasEnclosingInstanceInArgList"));
        }
        if (enclosingClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessInspection", "hasEnclosingInstanceInArgList"));
        }
        if (PsiImplUtil.hasNamedArguments(list)) {
            return false;
        }
        GrExpression[] args = list.getExpressionArguments();
        if (args.length == 0) {
            return false;
        }
        PsiType type = args[0].getType();
        PsiClassType enclosingClassType = JavaPsiFacade.getElementFactory((Project)list.getProject()).createType(enclosingClass);
        return TypesUtil.isAssignableByMethodCallConversion((PsiType)enclosingClassType, type, list);
    }

    @Nullable
    private static List<HighlightInfo> checkRefInner(GrReferenceExpression ref) {
        PsiElement refNameElement = ref.getReferenceNameElement();
        if (refNameElement == null) {
            return null;
        }
        boolean inStaticContext = PsiUtil.isCompileStatic(ref) || GrUnresolvedAccessInspection.isPropertyAccessInStaticMethod(ref);
        GroovyResolveResult resolveResult = GrUnresolvedAccessInspection.getBestResolveResult(ref);
        if (resolveResult.getElement() != null) {
            if (!GrUnresolvedAccessInspection.isInspectionEnabled(ref.getContainingFile(), ref.getProject())) {
                return null;
            }
            if (!GrUnresolvedAccessInspection.isStaticOk(resolveResult)) {
                String message = GroovyBundle.message("cannot.reference.non.static", ref.getReferenceName());
                return Collections.singletonList(GrUnresolvedAccessInspection.createAnnotationForRef(ref, inStaticContext, message));
            }
            return null;
        }
        if (ResolveUtil.isKeyOfMap(ref) || GrUnresolvedAccessInspection.isClassReference(ref)) {
            return null;
        }
        if (!inStaticContext) {
            if (!GrUnresolvedAccessInspection.isInspectionEnabled(ref.getContainingFile(), ref.getProject())) {
                return null;
            }
            GrUnresolvedAccessInspection inspection = GrUnresolvedAccessInspection.getInstance(ref.getContainingFile(), ref.getProject());
            assert (inspection != null);
            if (!inspection.myHighlightIfGroovyObjectOverridden && GrUnresolvedAccessInspection.areGroovyObjectMethodsOverridden(ref)) {
                return null;
            }
            if (!inspection.myHighlightIfMissingMethodsDeclared && GrUnresolvedAccessInspection.areMissingMethodsDeclared(ref)) {
                return null;
            }
            if (GroovySuppressableInspectionTool.isElementToolSuppressedIn(ref, SHORT_NAME)) {
                return null;
            }
        }
        if (inStaticContext || GrUnresolvedAccessInspection.shouldHighlightAsUnresolved(ref)) {
            HighlightInfo info = GrUnresolvedAccessInspection.createAnnotationForRef(ref, inStaticContext, GroovyBundle.message("cannot.resolve", ref.getReferenceName()));
            if (info == null) {
                return null;
            }
            ArrayList result = ContainerUtil.newArrayList();
            result.add(info);
            HighlightDisplayKey displayKey = HighlightDisplayKey.find((String)SHORT_NAME);
            if (ref.getParent() instanceof GrMethodCall) {
                ContainerUtil.addIfNotNull((Collection)result, (Object)GrUnresolvedAccessInspection.registerStaticImportFix(ref, displayKey));
            } else {
                GrUnresolvedAccessInspection.registerCreateClassByTypeFix(ref, info, displayKey);
                GrUnresolvedAccessInspection.registerAddImportFixes(ref, info, displayKey);
            }
            GrUnresolvedAccessInspection.registerReferenceFixes(ref, info, inStaticContext, displayKey);
            UnresolvedReferenceQuickFixProvider.registerReferenceFixes((PsiReference)ref, (QuickFixActionRegistrar)new QuickFixActionRegistrarAdapter(info, displayKey));
            OrderEntryFix.registerFixes((QuickFixActionRegistrar)new QuickFixActionRegistrarAdapter(info, displayKey), (PsiReference)ref);
            return result;
        }
        return null;
    }

    public static boolean isClassReference(GrReferenceExpression ref) {
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        return "class".equals(ref.getReferenceName()) && qualifier instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier).resolve() instanceof PsiClass && !PsiUtil.isThisReference(qualifier);
    }

    private static boolean areMissingMethodsDeclared(GrReferenceExpression ref) {
        PsiType qualifierType = GrReferenceResolveUtil.getQualifierType(ref);
        if (!(qualifierType instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolved = ((PsiClassType)qualifierType).resolve();
        if (resolved == null) {
            return false;
        }
        if (ref.getParent() instanceof GrCall) {
            PsiMethod[] found;
            for (PsiMethod method : found = resolved.findMethodsByName("methodMissing", true)) {
                if (!MissingMethodAndPropertyUtil.isMethodMissing(method)) continue;
                return true;
            }
        } else {
            PsiMethod[] found;
            for (PsiMethod method : found = resolved.findMethodsByName("propertyMissing", true)) {
                if (!MissingMethodAndPropertyUtil.isPropertyMissing(method)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean areGroovyObjectMethodsOverridden(GrReferenceExpression ref) {
        PsiMethod patternMethod = GrUnresolvedAccessInspection.findPatternMethod(ref);
        if (patternMethod == null) {
            return false;
        }
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        if (qualifier != null) {
            return GrUnresolvedAccessInspection.checkGroovyObjectMethodsByQualifier(ref, patternMethod);
        }
        return GrUnresolvedAccessInspection.checkMethodInPlace(ref, patternMethod);
    }

    private static boolean checkMethodInPlace(GrReferenceExpression ref, PsiMethod patternMethod) {
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{GrClosableBlock.class, PsiMember.class, PsiFile.class});
        assert (container != null);
        return GrUnresolvedAccessInspection.checkContainer(patternMethod, container);
    }

    private static boolean checkContainer(@NotNull PsiMethod patternMethod, @NotNull PsiElement container) {
        Boolean cachedResult;
        if (patternMethod == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessInspection", "checkContainer"));
        }
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessInspection", "checkContainer"));
        }
        String name = patternMethod.getName();
        ConcurrentMap cached = GROOVY_OBJECT_METHODS_CACHE.getCachedValue(container);
        if (cached == null) {
            cached = ContainerUtil.newConcurrentMap();
            GROOVY_OBJECT_METHODS_CACHE.putCachedValue(container, cached);
        }
        if ((cachedResult = cached.get(name)) != null) {
            return cachedResult;
        }
        boolean result = GrUnresolvedAccessInspection.doCheckContainer(patternMethod, container, name);
        cached.put(name, result);
        return result;
    }

    private static boolean doCheckContainer(final PsiMethod patternMethod, PsiElement container, final String name) {
        final Ref result = new Ref((Object)false);
        PsiScopeProcessor processor = new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessInspection$2", "execute"));
                }
                if (element instanceof PsiMethod && name.equals(((PsiMethod)element).getName()) && patternMethod.getParameterList().getParametersCount() == ((PsiMethod)element).getParameterList().getParametersCount() && GrUnresolvedAccessInspection.validateMethod((PsiMethod)element, patternMethod)) {
                    result.set((Object)true);
                    return false;
                }
                return true;
            }

            @Nullable
            public <T> T getHint(@NotNull Key<T> hintKey) {
                if (hintKey == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessInspection$2", "getHint"));
                }
                return null;
            }

            public void handleEvent(PsiScopeProcessor.Event event, @Nullable Object associated) {
            }
        };
        ResolveUtil.treeWalkUp(container, processor, true);
        return (Boolean)result.get();
    }

    private static boolean checkGroovyObjectMethodsByQualifier(GrReferenceExpression ref, PsiMethod patternMethod) {
        PsiType qualifierType = GrReferenceResolveUtil.getQualifierType(ref);
        if (!(qualifierType instanceof PsiClassType)) {
            return false;
        }
        PsiClass resolved = ((PsiClassType)qualifierType).resolve();
        if (resolved == null) {
            return false;
        }
        PsiMethod found = resolved.findMethodBySignature(patternMethod, true);
        if (found == null) {
            return false;
        }
        return GrUnresolvedAccessInspection.validateMethod(found, patternMethod);
    }

    private static boolean validateMethod(PsiMethod found, PsiMethod patternMethod) {
        PsiClass aClass = found.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String qname = aClass.getQualifiedName();
        if ("groovy.lang.GroovyObject".equals(qname)) {
            return false;
        }
        return !"groovy.lang.GroovyObjectSupport".equals(qname);
    }

    private static PsiMethod findPatternMethod(GrReferenceExpression ref) {
        PsiClass groovyObject = JavaPsiFacade.getInstance((Project)ref.getProject()).findClass("groovy.lang.GroovyObject", ref.getResolveScope());
        if (groovyObject == null) {
            return null;
        }
        String methodName = ref.getParent() instanceof GrCall ? "invokeMethod" : (PsiUtil.isLValue(ref) ? "setProperty" : "getProperty");
        PsiMethod[] patternMethods = groovyObject.findMethodsByName(methodName, false);
        if (patternMethods.length != 1) {
            return null;
        }
        return patternMethods[0];
    }

    private static void addEmptyIntentionIfNeeded(@Nullable HighlightInfo info) {
        if (info != null) {
            int s2;
            int s1 = info.quickFixActionMarkers != null ? info.quickFixActionMarkers.size() : 0;
            int n = s2 = info.quickFixActionRanges != null ? info.quickFixActionRanges.size() : 0;
            if (s1 + s2 == 0) {
                EmptyIntentionAction emptyIntentionAction = new EmptyIntentionAction("Access to unresolved expression");
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)emptyIntentionAction, (HighlightDisplayKey)HighlightDisplayKey.find((String)SHORT_NAME));
            }
        }
    }

    private static boolean isResolvedStaticImport(GrCodeReferenceElement refElement) {
        PsiElement parent = refElement.getParent();
        return parent instanceof GrImportStatement && ((GrImportStatement)parent).isStatic() && refElement.multiResolve(false).length > 0;
    }

    private static boolean isStaticOk(GroovyResolveResult resolveResult) {
        if (resolveResult.isStaticsOK()) {
            return true;
        }
        PsiElement resolved = resolveResult.getElement();
        LOG.assertTrue(resolved != null);
        LOG.assertTrue(resolved instanceof PsiModifierListOwner, (Object)(resolved + " : " + resolved.getText()));
        return ((PsiModifierListOwner)resolved).hasModifierProperty("static");
    }

    private static GroovyResolveResult getBestResolveResult(GrReferenceExpression ref) {
        GroovyResolveResult[] results = ref.multiResolve(false);
        if (results.length == 0) {
            return GroovyResolveResult.EMPTY_RESULT;
        }
        if (results.length == 1) {
            return results[0];
        }
        for (GroovyResolveResult result : results) {
            if (!result.isAccessible() || !result.isStaticsOK()) continue;
            return result;
        }
        for (GroovyResolveResult result : results) {
            if (!result.isStaticsOK()) continue;
            return result;
        }
        return results[0];
    }

    public static boolean isPropertyAccessInStaticMethod(GrReferenceExpression referenceExpression) {
        return GrUnresolvedAccessInspection.isInStaticContext(referenceExpression) && !(referenceExpression.getParent() instanceof GrMethodCall) && referenceExpression.getQualifier() == null;
    }

    private static boolean isInStaticContext(PsiElement place) {
        GrMember context = (GrMember)PsiTreeUtil.getParentOfType((PsiElement)place, GrMember.class, (boolean)true, (Class[])new Class[]{GrClosableBlock.class});
        return (context instanceof GrMethod || context instanceof GrClassInitializer) && context.hasModifierProperty("static");
    }

    @Nullable
    private static HighlightInfo createAnnotationForRef(@NotNull GrReferenceElement ref, boolean strongError, @NotNull String message) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessInspection", "createAnnotationForRef"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessInspection", "createAnnotationForRef"));
        }
        PsiElement refNameElement = ref.getReferenceNameElement();
        assert (refNameElement != null);
        if (strongError) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range(refNameElement).descriptionAndTooltip(message).create();
        }
        HighlightDisplayLevel displayLevel = GrUnresolvedAccessInspection.getHighlightDisplayLevel(ref.getProject(), ref);
        if (displayLevel == HighlightDisplayLevel.ERROR) {
            return HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WRONG_REF).range(refNameElement).descriptionAndTooltip(message).create();
        }
        if (displayLevel == HighlightDisplayLevel.WEAK_WARNING) {
            boolean isTestMode = ApplicationManager.getApplication().isUnitTestMode();
            HighlightInfoType infotype = isTestMode ? HighlightInfoType.WARNING : HighlightInfoType.INFORMATION;
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)infotype).range(refNameElement);
            builder.descriptionAndTooltip(message);
            return builder.needsUpdateOnTyping(false).textAttributes(DefaultHighlighter.UNRESOLVED_ACCESS).create();
        }
        HighlightInfoType highlightInfoType = HighlightInfo.convertSeverity((HighlightSeverity)displayLevel.getSeverity());
        return HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(refNameElement).descriptionAndTooltip(message).create();
    }

    private static HighlightInfo registerStaticImportFix(@NotNull GrReferenceExpression referenceExpression, @Nullable HighlightDisplayKey key) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessInspection", "registerStaticImportFix"));
        }
        String referenceName = referenceExpression.getReferenceName();
        if (StringUtil.isEmpty((String)referenceName)) {
            return null;
        }
        if (referenceExpression.getQualifier() != null) {
            return null;
        }
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).range(referenceExpression.getParent()).createUnconditionally();
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new GroovyStaticImportMethodFix((GrMethodCall)referenceExpression.getParent()), (HighlightDisplayKey)key);
        return info;
    }

    private static void registerReferenceFixes(GrReferenceExpression refExpr, HighlightInfo info, boolean compileStatic, HighlightDisplayKey key) {
        PsiClass targetClass = QuickfixUtil.findTargetClass(refExpr, compileStatic);
        if (targetClass == null) {
            return;
        }
        if (!(targetClass instanceof SyntheticElement) || targetClass instanceof GroovyScriptClass) {
            if (!compileStatic) {
                GrUnresolvedAccessInspection.addDynamicAnnotation(info, refExpr, key);
            }
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new CreateFieldFromUsageFix(refExpr), (HighlightDisplayKey)key);
            if (PsiUtil.isAccessedForReading(refExpr)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new CreateGetterFromUsageFix(refExpr, targetClass), (HighlightDisplayKey)key);
            }
            if (PsiUtil.isLValue(refExpr)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new CreateSetterFromUsageFix(refExpr), (HighlightDisplayKey)key);
            }
            if (refExpr.getParent() instanceof GrCall && refExpr.getParent() instanceof GrExpression) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new CreateMethodFromUsageFix(refExpr), (HighlightDisplayKey)key);
            }
        }
        if (!refExpr.isQualified()) {
            GrVariableDeclarationOwner owner = (GrVariableDeclarationOwner)PsiTreeUtil.getParentOfType((PsiElement)refExpr, GrVariableDeclarationOwner.class);
            if (!(owner instanceof GroovyFileBase) || ((GroovyFileBase)owner).isScript()) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new CreateLocalVariableFromUsageFix(refExpr, owner), (HighlightDisplayKey)key);
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)refExpr, GrMethod.class) != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new CreateParameterFromUsageFix(refExpr), (HighlightDisplayKey)key);
            }
        }
    }

    private static void addDynamicAnnotation(HighlightInfo info, GrReferenceExpression referenceExpression, HighlightDisplayKey key) {
        PsiFile containingFile = referenceExpression.getContainingFile();
        if (containingFile != null) {
            VirtualFile file = containingFile.getVirtualFile();
            if (file == null) {
                return;
            }
        } else {
            return;
        }
        if (QuickfixUtil.isCall(referenceExpression)) {
            PsiType[] argumentTypes = PsiUtil.getArgumentTypes(referenceExpression, false);
            if (argumentTypes != null) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (TextRange)referenceExpression.getTextRange(), (IntentionAction)new DynamicMethodFix(referenceExpression, argumentTypes), (HighlightDisplayKey)key);
            }
        } else {
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (TextRange)referenceExpression.getTextRange(), (IntentionAction)new DynamicPropertyFix(referenceExpression), (HighlightDisplayKey)key);
        }
    }

    private static void registerAddImportFixes(GrReferenceElement refElement, @Nullable HighlightInfo info, HighlightDisplayKey key) {
        String referenceName = refElement.getReferenceName();
        if (StringUtil.isEmpty((String)referenceName)) {
            return;
        }
        if (!(refElement instanceof GrCodeReferenceElement) && Character.isLowerCase(referenceName.charAt(0))) {
            return;
        }
        if (refElement.getQualifier() != null) {
            return;
        }
        QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)new GroovyAddImportAction(refElement), (HighlightDisplayKey)key);
    }

    private static void registerCreateClassByTypeFix(@NotNull GrReferenceElement refElement, @Nullable HighlightInfo info, HighlightDisplayKey key) {
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessInspection", "registerCreateClassByTypeFix"));
        }
        GrPackageDefinition packageDefinition = (GrPackageDefinition)PsiTreeUtil.getParentOfType((PsiElement)refElement, GrPackageDefinition.class);
        if (packageDefinition != null) {
            return;
        }
        PsiElement parent = refElement.getParent();
        if (parent instanceof GrNewExpression && refElement.getManager().areElementsEquivalent((PsiElement)((GrNewExpression)parent).getReferenceElement(), (PsiElement)refElement)) {
            QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)CreateClassFix.createClassFromNewAction((GrNewExpression)parent), (HighlightDisplayKey)key);
        } else if (GrUnresolvedAccessInspection.canBeClassOrPackage(refElement)) {
            if (GrUnresolvedAccessInspection.shouldBeInterface(refElement)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)CreateClassFix.createClassFixAction(refElement, CreateClassKind.INTERFACE), (HighlightDisplayKey)key);
            } else if (GrUnresolvedAccessInspection.shouldBeClass(refElement)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)CreateClassFix.createClassFixAction(refElement, CreateClassKind.CLASS), (HighlightDisplayKey)key);
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)CreateClassFix.createClassFixAction(refElement, CreateClassKind.ENUM), (HighlightDisplayKey)key);
            } else if (GrUnresolvedAccessInspection.shouldBeAnnotation(refElement)) {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)CreateClassFix.createClassFixAction(refElement, CreateClassKind.ANNOTATION), (HighlightDisplayKey)key);
            } else {
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)CreateClassFix.createClassFixAction(refElement, CreateClassKind.CLASS), (HighlightDisplayKey)key);
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)CreateClassFix.createClassFixAction(refElement, CreateClassKind.INTERFACE), (HighlightDisplayKey)key);
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)CreateClassFix.createClassFixAction(refElement, CreateClassKind.ENUM), (HighlightDisplayKey)key);
                QuickFixAction.registerQuickFixAction((HighlightInfo)info, (IntentionAction)CreateClassFix.createClassFixAction(refElement, CreateClassKind.ANNOTATION), (HighlightDisplayKey)key);
            }
        }
    }

    private static boolean canBeClassOrPackage(@NotNull GrReferenceElement refElement) {
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessInspection", "canBeClassOrPackage"));
        }
        return !(refElement instanceof GrReferenceExpression) || ResolveUtil.canBeClassOrPackage((GrReferenceExpression)refElement);
    }

    private static boolean shouldBeAnnotation(GrReferenceElement element) {
        return element.getParent() instanceof GrAnnotation;
    }

    private static boolean shouldBeInterface(GrReferenceElement myRefElement) {
        PsiElement parent = myRefElement.getParent();
        return parent instanceof GrImplementsClause || parent instanceof GrExtendsClause && parent.getParent() instanceof GrInterfaceDefinition;
    }

    private static boolean shouldBeClass(GrReferenceElement myRefElement) {
        PsiElement parent = myRefElement.getParent();
        return parent instanceof GrExtendsClause && !(parent.getParent() instanceof GrInterfaceDefinition);
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Probable bugs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessInspection", "getGroupDisplayName"));
        }
        return "Probable bugs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Access to unresolved expression" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessInspection", "getDisplayName"));
        }
        return "Access to unresolved expression";
    }

    private static class QuickFixActionRegistrarAdapter
    implements QuickFixActionRegistrar {
        private final HighlightInfo myInfo;
        private HighlightDisplayKey myKey;

        public QuickFixActionRegistrarAdapter(@Nullable HighlightInfo info, HighlightDisplayKey displayKey) {
            this.myInfo = info;
            this.myKey = displayKey;
        }

        public void register(@NotNull IntentionAction action) {
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessInspection$QuickFixActionRegistrarAdapter", "register"));
            }
            this.myKey = HighlightDisplayKey.find((String)GrUnresolvedAccessInspection.SHORT_NAME);
            QuickFixAction.registerQuickFixAction((HighlightInfo)this.myInfo, (IntentionAction)action, (HighlightDisplayKey)this.myKey);
        }

        public void register(@NotNull TextRange fixRange, @NotNull IntentionAction action, HighlightDisplayKey key) {
            if (fixRange == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessInspection$QuickFixActionRegistrarAdapter", "register"));
            }
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessInspection$QuickFixActionRegistrarAdapter", "register"));
            }
            QuickFixAction.registerQuickFixAction((HighlightInfo)this.myInfo, (TextRange)fixRange, (IntentionAction)action, (HighlightDisplayKey)key);
        }

        public void unregister(@NotNull Condition<IntentionAction> condition) {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GrUnresolvedAccessInspection$QuickFixActionRegistrarAdapter", "unregister"));
            }
            if (this.myInfo != null) {
                this.myInfo.unregisterQuickFix(condition);
            }
        }
    }
}

