/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GroovyWaitCallNotInLoopInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Threading issues" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyWaitCallNotInLoopInspection", "getGroupDisplayName"));
        }
        return "Threading issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("'wait()' not in loop" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyWaitCallNotInLoopInspection", "getDisplayName"));
        }
        return "'wait()' not in loop";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Call to'#ref' outside of loop #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethodCallExpression(GrMethodCallExpression grMethodCallExpression) {
            super.visitMethodCallExpression(grMethodCallExpression);
            GrExpression methodExpression = grMethodCallExpression.getInvokedExpression();
            if (!(methodExpression instanceof GrReferenceExpression)) {
                return;
            }
            GrReferenceExpression reference = (GrReferenceExpression)methodExpression;
            String name = reference.getReferenceName();
            if (!"wait".equals(name)) {
                return;
            }
            PsiMethod method = grMethodCallExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName())) {
                return;
            }
            if (ControlFlowUtils.isInLoop(grMethodCallExpression)) {
                return;
            }
            this.registerMethodCallError(grMethodCallExpression, new Object[0]);
        }
    }
}

