/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.spellchecker;

import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.EscapeSequenceTokenizer;
import com.intellij.spellchecker.tokenizer.SuppressibleSpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.GroovySuppressableInspectionTool;
import org.jetbrains.plugins.groovy.codeInspection.spellchecker.GrDocCommentTokenizer;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class GroovySpellcheckingStrategy
extends SuppressibleSpellcheckingStrategy {
    private final GrDocCommentTokenizer myDocCommentTokenizer = new GrDocCommentTokenizer();
    private final Tokenizer<PsiElement> myStringTokenizer = new Tokenizer<PsiElement>(){

        public void tokenize(@NotNull PsiElement literal, TokenConsumer consumer) {
            if (literal == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/spellchecker/GroovySpellcheckingStrategy$1", "tokenize"));
            }
            String text = GrStringUtil.removeQuotes(literal.getText());
            if (!text.contains("\\")) {
                consumer.consumeToken(literal, (Splitter)PlainTextSplitter.getInstance());
            } else {
                StringBuilder unescapedText = new StringBuilder();
                int[] offsets = new int[text.length() + 1];
                GrStringUtil.parseStringCharacters(text, unescapedText, offsets);
                EscapeSequenceTokenizer.processTextWithOffsets((PsiElement)literal, (TokenConsumer)consumer, (StringBuilder)unescapedText, (int[])offsets, (int)GrStringUtil.getStartQuote(literal.getText()).length());
            }
        }
    };

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        PsiElement name;
        if (TokenSets.STRING_LITERAL_SET.contains(element.getNode().getElementType())) {
            Tokenizer<PsiElement> tokenizer = this.myStringTokenizer;
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/spellchecker/GroovySpellcheckingStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        if (element instanceof GrNamedElement && TokenSets.STRING_LITERAL_SET.contains((name = ((GrNamedElement)element).getNameIdentifierGroovy()).getNode().getElementType())) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/spellchecker/GroovySpellcheckingStrategy", "getTokenizer"));
            }
            return tokenizer;
        }
        if (element instanceof PsiDocComment) {
            GrDocCommentTokenizer grDocCommentTokenizer = this.myDocCommentTokenizer;
            if (grDocCommentTokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/spellchecker/GroovySpellcheckingStrategy", "getTokenizer"));
            }
            return grDocCommentTokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/spellchecker/GroovySpellcheckingStrategy", "getTokenizer"));
        }
        return tokenizer;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String name) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/spellchecker/GroovySpellcheckingStrategy", "isSuppressedFor"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/codeInspection/spellchecker/GroovySpellcheckingStrategy", "isSuppressedFor"));
        }
        return GroovySuppressableInspectionTool.getElementToolSuppressedIn(element, name) != null;
    }

    public SuppressQuickFix[] getSuppressActions(@NotNull PsiElement element, @NotNull String name) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/spellchecker/GroovySpellcheckingStrategy", "getSuppressActions"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "org/jetbrains/plugins/groovy/codeInspection/spellchecker/GroovySpellcheckingStrategy", "getSuppressActions"));
        }
        return GroovySuppressableInspectionTool.getSuppressActions(name);
    }
}

