/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.naming.ConventionInspection;
import org.jetbrains.plugins.groovy.codeInspection.naming.RenameFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;

public class GroovyStaticVariableNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 4;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @NotNull
    public String getDisplayName() {
        if ("Static variable naming convention" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyStaticVariableNamingConventionInspection", "getDisplayName"));
        }
        return "Static variable naming convention";
    }

    @Override
    protected GroovyFix buildFix(PsiElement location) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            if ("Static variable name '#ref' is too short" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyStaticVariableNamingConventionInspection", "buildErrorString"));
            }
            return "Static variable name '#ref' is too short";
        }
        if (className.length() > this.getMaxLength()) {
            if ("Static variable name '#ref' is too long" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyStaticVariableNamingConventionInspection", "buildErrorString"));
            }
            return "Static variable name '#ref' is too long";
        }
        String string = "Static variable name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyStaticVariableNamingConventionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected String getDefaultRegex() {
        return "s_[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 4;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitField(GrField grField) {
            super.visitField(grField);
            if (!grField.hasModifierProperty("static")) {
                return;
            }
            if (grField.hasModifierProperty("final")) {
                return;
            }
            String name = grField.getName();
            if (GroovyStaticVariableNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerVariableError(grField, name);
        }
    }
}

