/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.naming.ConventionInspection;
import org.jetbrains.plugins.groovy.codeInspection.naming.RenameFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;

public class GroovyEnumerationNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 8;
    private static final int DEFAULT_MAX_LENGTH = 64;

    @NotNull
    public String getDisplayName() {
        if ("Enumeration naming convention" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyEnumerationNamingConventionInspection", "getDisplayName"));
        }
        return "Enumeration naming convention";
    }

    @Override
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyEnumerationNamingConventionInspection", "buildFix"));
        }
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            if ("Enumeration name '#ref' is too short" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyEnumerationNamingConventionInspection", "buildErrorString"));
            }
            return "Enumeration name '#ref' is too short";
        }
        if (className.length() > this.getMaxLength()) {
            if ("Enumeration name '#ref' is too long" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyEnumerationNamingConventionInspection", "buildErrorString"));
            }
            return "Enumeration name '#ref' is too long";
        }
        String string = "Enumeration name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyEnumerationNamingConventionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected String getDefaultRegex() {
        return "[A-Z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 8;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 64;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        NamingConventionsVisitor namingConventionsVisitor = new NamingConventionsVisitor();
        if (namingConventionsVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyEnumerationNamingConventionInspection", "buildVisitor"));
        }
        return namingConventionsVisitor;
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitEnumDefinition(GrEnumTypeDefinition aClass) {
            super.visitEnumDefinition(aClass);
            String name = aClass.getName();
            if (name == null) {
                return;
            }
            if (GroovyEnumerationNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerClassError(aClass, name);
        }
    }
}

