/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.naming.ConventionInspection;
import org.jetbrains.plugins.groovy.codeInspection.naming.RenameFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;

public class GroovyConstantNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 4;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @NotNull
    public String getDisplayName() {
        if ("Constant naming convention" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyConstantNamingConventionInspection", "getDisplayName"));
        }
        return "Constant naming convention";
    }

    @Override
    protected GroovyFix buildFix(PsiElement location) {
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            if ("Constant name '#ref' is too short" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyConstantNamingConventionInspection", "buildErrorString"));
            }
            return "Constant name '#ref' is too short";
        }
        if (className.length() > this.getMaxLength()) {
            if ("Constant name '#ref' is too long" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyConstantNamingConventionInspection", "buildErrorString"));
            }
            return "Constant name '#ref' is too long";
        }
        String string = "Constant name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyConstantNamingConventionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected String getDefaultRegex() {
        return "[A-Z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 4;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitField(GrField grField) {
            super.visitField(grField);
            if (!grField.hasModifierProperty("static") || !grField.hasModifierProperty("final")) {
                return;
            }
            String name = grField.getName();
            if (GroovyConstantNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerVariableError(grField, name);
        }
    }
}

