/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.naming.ConventionInspection;
import org.jetbrains.plugins.groovy.codeInspection.naming.RenameFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrClassDefinition;

public class GroovyClassNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 8;
    private static final int DEFAULT_MAX_LENGTH = 64;

    @NotNull
    public String getDisplayName() {
        if ("Class naming convention" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyClassNamingConventionInspection", "getDisplayName"));
        }
        return "Class naming convention";
    }

    @Override
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyClassNamingConventionInspection", "buildFix"));
        }
        return new RenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            if ("Class name '#ref' is too short" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyClassNamingConventionInspection", "buildErrorString"));
            }
            return "Class name '#ref' is too short";
        }
        if (className.length() > this.getMaxLength()) {
            if ("Class name '#ref' is too long" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyClassNamingConventionInspection", "buildErrorString"));
            }
            return "Class name '#ref' is too long";
        }
        String string = "Class name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyClassNamingConventionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected String getDefaultRegex() {
        return "[A-Z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 8;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 64;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        NamingConventionsVisitor namingConventionsVisitor = new NamingConventionsVisitor();
        if (namingConventionsVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyClassNamingConventionInspection", "buildVisitor"));
        }
        return namingConventionsVisitor;
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitClassDefinition(GrClassDefinition classDefinition) {
            super.visitClassDefinition(classDefinition);
            String name = classDefinition.getName();
            if (name == null) {
                return;
            }
            if (GroovyClassNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerClassError(classDefinition, name);
        }
    }
}

