/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.metrics;

import com.intellij.psi.PsiType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.metrics.GroovyMethodMetricInspection;
import org.jetbrains.plugins.groovy.codeInspection.metrics.ReturnPointCountVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GroovyMultipleReturnPointsPerMethodInspection
extends GroovyMethodMetricInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Method Metrics" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyMultipleReturnPointsPerMethodInspection", "getGroupDisplayName"));
        }
        return "Method Metrics";
    }

    @NotNull
    public String getDisplayName() {
        if ("Method with multiple return points" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyMultipleReturnPointsPerMethodInspection", "getDisplayName"));
        }
        return "Method with multiple return points";
    }

    @Override
    protected int getDefaultLimit() {
        return 1;
    }

    @Override
    protected String getConfigurationLabel() {
        return "Return point limit:";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer returnPointCount = (Integer)infos[0];
        String string = "<code>#ref</code> has " + returnPointCount + " return points #loc";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyMultipleReturnPointsPerMethodInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MultipleReturnPointsVisitor();
    }

    private class MultipleReturnPointsVisitor
    extends BaseInspectionVisitor {
        private MultipleReturnPointsVisitor() {
        }

        @Override
        public void visitMethod(@NotNull GrMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/metrics/GroovyMultipleReturnPointsPerMethodInspection$MultipleReturnPointsVisitor", "visitMethod"));
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            int returnPointCount = this.calculateReturnPointCount(method);
            if (returnPointCount <= GroovyMultipleReturnPointsPerMethodInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, returnPointCount);
        }

        private int calculateReturnPointCount(GrMethod method) {
            ReturnPointCountVisitor visitor = new ReturnPointCountVisitor();
            method.accept(visitor);
            int count = visitor.getCount();
            if (!this.mayFallThroughBottom(method)) {
                return count;
            }
            GrOpenBlock body = method.getBlock();
            if (body == null) {
                return count;
            }
            GrStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return count + 1;
            }
            GrStatement lastStatement = statements[statements.length - 1];
            if (ControlFlowUtils.statementMayCompleteNormally(lastStatement)) {
                return count + 1;
            }
            return count;
        }

        private boolean mayFallThroughBottom(GrMethod method) {
            if (method.isConstructor()) {
                return true;
            }
            PsiType returnType = method.getReturnType();
            return PsiType.VOID.equals((Object)returnType);
        }
    }
}

