/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.local;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeInfoImpl;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrChangeSignatureProcessor;
import org.jetbrains.plugins.groovy.refactoring.changeSignature.GrParameterInfo;

public class RemoveUnusedGrParameterFix
implements IntentionAction {
    private String myName;

    public RemoveUnusedGrParameterFix(GrParameter parameter) {
        this.myName = parameter.getName();
    }

    @NotNull
    public String getText() {
        String string = GroovyIntentionsBundle.message("remove.parameter.0", this.myName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/local/RemoveUnusedGrParameterFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyIntentionsBundle.message("remove.unused.parameter", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/local/RemoveUnusedGrParameterFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/local/RemoveUnusedGrParameterFix", "isAvailable"));
        }
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        GrParameter parameter = (GrParameter)PsiTreeUtil.getParentOfType((PsiElement)at, GrParameter.class);
        return parameter != null && this.myName.equals(parameter.getName());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/local/RemoveUnusedGrParameterFix", "invoke"));
        }
        PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
        GrParameter parameter = (GrParameter)PsiTreeUtil.getParentOfType((PsiElement)at, GrParameter.class);
        if (parameter == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(parameter.getContainingFile())) {
            return;
        }
        GrMethod method = (GrMethod)parameter.getDeclarationScope();
        GrChangeSignatureProcessor processor = new GrChangeSignatureProcessor(parameter.getProject(), RemoveUnusedGrParameterFix.createChangeInfo(method, parameter));
        processor.run();
    }

    private static GrChangeInfoImpl createChangeInfo(GrMethod method, GrParameter parameter) {
        ArrayList<GrParameterInfo> params = new ArrayList<GrParameterInfo>();
        int i = 0;
        for (GrParameter p : method.getParameterList().getParameters()) {
            if (p != parameter) {
                params.add(new GrParameterInfo(p, i));
            }
            ++i;
        }
        GrTypeElement typeElement = method.getReturnTypeElementGroovy();
        CanonicalTypes.Type wrapper = typeElement != null ? CanonicalTypes.createTypeWrapper((PsiType)method.getReturnType()) : null;
        return new GrChangeInfoImpl(method, null, wrapper, method.getName(), params, null, false);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

