/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.intentions.base.IntentionUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrElvisExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;

public class GroovyConditionalCanBeElvisInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        if ("Conditional expression can be elvis" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalCanBeElvisInspection", "getDisplayName"));
        }
        return "Conditional expression can be elvis";
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("Control Flow" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalCanBeElvisInspection", "getGroupDisplayName"));
        }
        return "Control Flow";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "Conditional expression can be elvis #loc";
    }

    @Override
    public GroovyFix buildFix(PsiElement location) {
        return new GroovyFix(){

            @NotNull
            public String getName() {
                if ("Convert Conditional to Elvis" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalCanBeElvisInspection$1", "getName"));
                }
                return "Convert Conditional to Elvis";
            }

            @Override
            public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
                GrConditionalExpression expr = (GrConditionalExpression)descriptor.getPsiElement();
                GrExpression condition = expr.getCondition();
                GrExpression thenExpression = expr.getThenBranch();
                GrExpression elseExpression = expr.getElseBranch();
                assert (elseExpression != null);
                assert (thenExpression != null);
                String newExpression = GroovyConditionalCanBeElvisInspection.checkForStringIsEmpty(condition, elseExpression) || GroovyConditionalCanBeElvisInspection.checkForListIsEmpty(condition, elseExpression) || GroovyConditionalCanBeElvisInspection.checkForEqualsNotElse(condition, elseExpression) ? elseExpression.getText() + " ?: " + thenExpression.getText() : thenExpression.getText() + " ?: " + elseExpression.getText();
                IntentionUtils.replaceExpression(newExpression, expr);
            }
        };
    }

    private static boolean checkPsiElement(GrConditionalExpression expr) {
        if (expr instanceof GrElvisExpression) {
            return false;
        }
        GrExpression condition = expr.getCondition();
        GrExpression then = expr.getThenBranch();
        GrExpression elseBranch = expr.getElseBranch();
        if (then == null || elseBranch == null) {
            return false;
        }
        return GroovyConditionalCanBeElvisInspection.checkForEqualsThen(condition, then) || GroovyConditionalCanBeElvisInspection.checkForEqualsNotElse(condition, elseBranch) || GroovyConditionalCanBeElvisInspection.checkForNull(condition, then) || GroovyConditionalCanBeElvisInspection.checkForStringIsEmpty(condition, elseBranch) || GroovyConditionalCanBeElvisInspection.checkForStringIsNotEmpty(condition, then) || GroovyConditionalCanBeElvisInspection.checkForListIsEmpty(condition, elseBranch) || GroovyConditionalCanBeElvisInspection.checkForListIsNotEmpty(condition, then);
    }

    private static boolean checkForEqualsNotElse(GrExpression condition, GrExpression elseBranch) {
        if (!(condition instanceof GrUnaryExpression)) {
            return false;
        }
        if (((GrUnaryExpression)condition).getOperationTokenType() != GroovyTokenTypes.mLNOT) {
            return false;
        }
        GrExpression operand = ((GrUnaryExpression)condition).getOperand();
        return operand != null && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)operand, (PsiElement)elseBranch);
    }

    private static boolean checkForEqualsThen(GrExpression condition, GrExpression then) {
        return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)condition, (PsiElement)then);
    }

    private static boolean checkForListIsNotEmpty(GrExpression condition, GrExpression then) {
        if (!(condition instanceof GrUnaryExpression)) {
            return false;
        }
        if (((GrUnaryExpression)condition).getOperationTokenType() != GroovyTokenTypes.mLNOT) {
            return false;
        }
        return GroovyConditionalCanBeElvisInspection.checkForListIsEmpty(((GrUnaryExpression)condition).getOperand(), then);
    }

    private static boolean checkForListIsEmpty(GrExpression condition, GrExpression elseBranch) {
        if (condition instanceof GrMethodCall) {
            condition = ((GrMethodCall)condition).getInvokedExpression();
        }
        if (!(condition instanceof GrReferenceExpression)) {
            return false;
        }
        GrExpression qualifier = (GrExpression)((GrReferenceExpression)condition).getQualifier();
        if (qualifier == null) {
            return false;
        }
        if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)elseBranch)) {
            return false;
        }
        PsiType type = qualifier.getType();
        if (type == null) {
            return false;
        }
        if (!InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.List")) {
            return false;
        }
        PsiElement resolved = ((GrReferenceExpression)condition).resolve();
        return resolved instanceof PsiMethod && "isEmpty".equals(((PsiMethod)resolved).getName()) && ((PsiMethod)resolved).getParameterList().getParametersCount() == 0;
    }

    private static boolean checkForStringIsNotEmpty(GrExpression condition, GrExpression then) {
        if (!(condition instanceof GrUnaryExpression)) {
            return false;
        }
        if (((GrUnaryExpression)condition).getOperationTokenType() != GroovyTokenTypes.mLNOT) {
            return false;
        }
        return GroovyConditionalCanBeElvisInspection.checkForStringIsEmpty(((GrUnaryExpression)condition).getOperand(), then);
    }

    private static boolean checkForStringIsEmpty(GrExpression condition, GrExpression elseBranch) {
        if (condition instanceof GrMethodCall) {
            condition = ((GrMethodCall)condition).getInvokedExpression();
        }
        if (!(condition instanceof GrReferenceExpression)) {
            return false;
        }
        GrExpression qualifier = (GrExpression)((GrReferenceExpression)condition).getQualifier();
        if (qualifier == null) {
            return false;
        }
        if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)qualifier, (PsiElement)elseBranch)) {
            return false;
        }
        PsiType type = qualifier.getType();
        if (type == null) {
            return false;
        }
        if (!type.equalsToText("java.lang.String")) {
            return false;
        }
        PsiElement resolved = ((GrReferenceExpression)condition).resolve();
        return resolved instanceof PsiMethod && "isEmpty".equals(((PsiMethod)resolved).getName()) && ((PsiMethod)resolved).getParameterList().getParametersCount() == 0;
    }

    private static boolean checkForNull(GrExpression condition, GrExpression then) {
        if (!(condition instanceof GrBinaryExpression)) {
            return false;
        }
        GrBinaryExpression binaryExpression = (GrBinaryExpression)condition;
        if (GroovyTokenTypes.mNOT_EQUAL != binaryExpression.getOperationTokenType()) {
            return false;
        }
        GrExpression left = binaryExpression.getLeftOperand();
        GrExpression right = binaryExpression.getRightOperand();
        if (left instanceof GrLiteral && "null".equals(left.getText()) && right != null) {
            return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)right, (PsiElement)then);
        }
        if (right instanceof GrLiteral && "null".equals(right.getText())) {
            return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)left, (PsiElement)then);
        }
        return false;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitConditionalExpression(GrConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            if (GroovyConditionalCanBeElvisInspection.checkPsiElement(expression)) {
                this.registerError(expression);
            }
        }
    }
}

