/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeStyle.GrReferenceAdjuster;
import org.jetbrains.plugins.groovy.codeStyle.GroovyCodeStyleSettings;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

public class UnnecessaryQualifiedReferenceInspection
extends BaseInspection {
    private static final Logger LOG = Logger.getInstance(UnnecessaryQualifiedReferenceInspection.class);

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        BaseInspectionVisitor baseInspectionVisitor = new BaseInspectionVisitor(){

            @Override
            public void visitCodeReferenceElement(GrCodeReferenceElement refElement) {
                super.visitCodeReferenceElement(refElement);
                if (UnnecessaryQualifiedReferenceInspection.canBeSimplified(refElement)) {
                    this.registerError(refElement);
                }
            }

            @Override
            public void visitReferenceExpression(GrReferenceExpression referenceExpression) {
                super.visitReferenceExpression(referenceExpression);
                if (UnnecessaryQualifiedReferenceInspection.canBeSimplified(referenceExpression) || UnnecessaryQualifiedReferenceInspection.isQualifiedStaticMethodWithUnnecessaryQualifier(referenceExpression)) {
                    this.registerError(referenceExpression);
                }
            }
        };
        if (baseInspectionVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/UnnecessaryQualifiedReferenceInspection", "buildVisitor"));
        }
        return baseInspectionVisitor;
    }

    private static boolean isQualifiedStaticMethodWithUnnecessaryQualifier(GrReferenceExpression ref) {
        PsiElement copyResolved;
        if (ref.getQualifier() == null) {
            return false;
        }
        PsiElement resolved = ref.resolve();
        if (!(resolved instanceof PsiMember)) {
            return false;
        }
        if (!((PsiMember)resolved).hasModifierProperty("static")) {
            return false;
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof GrMethodCall) {
            GrMethodCall copy = (GrMethodCall)parent.copy();
            GrReferenceExpression invoked = (GrReferenceExpression)copy.getInvokedExpression();
            assert (invoked != null);
            invoked.setQualifier(null);
            copyResolved = ((GrReferenceExpression)copy.getInvokedExpression()).resolve();
        } else {
            GrReferenceExpression copy = (GrReferenceExpression)ref.copy();
            copy.setQualifier(null);
            copyResolved = copy.resolve();
        }
        return ref.getManager().areElementsEquivalent(copyResolved, resolved);
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Potentially confusing code constructs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/UnnecessaryQualifiedReferenceInspection", "getGroupDisplayName"));
        }
        return "Potentially confusing code constructs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GroovyInspectionBundle.message("unnecessary.qualified.reference", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/UnnecessaryQualifiedReferenceInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return GroovyInspectionBundle.message("unnecessary.qualified.reference", new Object[0]);
    }

    @Override
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "org/jetbrains/plugins/groovy/codeInspection/confusing/UnnecessaryQualifiedReferenceInspection", "buildFix"));
        }
        return new GroovyFix(){

            @Override
            protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
                PsiElement startElement = descriptor.getStartElement();
                LOG.assertTrue(startElement instanceof GrReferenceElement);
                GrReferenceAdjuster.shortenReference((GrQualifiedReference)startElement);
            }

            @NotNull
            public String getName() {
                String string = GroovyInspectionBundle.message("replace.qualified.name.with.import", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/UnnecessaryQualifiedReferenceInspection$2", "getName"));
                }
                return string;
            }
        };
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    private static boolean canBeSimplified(PsiElement element) {
        GrReferenceElement ref;
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class) != null) {
            return false;
        }
        if (element instanceof GrCodeReferenceElement) {
            if (PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{GrImportStatement.class, GrPackageDefinition.class}) != null) {
                return false;
            }
        } else if (element instanceof GrReferenceExpression) {
            if (!GrReferenceAdjuster.seemsToBeQualifiedClassName((GrReferenceExpression)element)) {
                return false;
            }
        } else {
            return false;
        }
        if ((ref = (GrReferenceElement)element).getQualifier() == null) {
            return false;
        }
        if (!(ref.getContainingFile() instanceof GroovyFileBase)) {
            return false;
        }
        PsiElement resolved = ref.resolve();
        if (!(resolved instanceof PsiClass)) {
            return false;
        }
        String name = ((PsiClass)resolved).getName();
        if (name == null) {
            return false;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(element.getProject());
        GrReferenceExpression shortedRef = factory.createReferenceExpressionFromText(name, element);
        GroovyResolveResult resolveResult = shortedRef.advancedResolve();
        if (element.getManager().areElementsEquivalent(resolved, resolveResult.getElement())) {
            return true;
        }
        PsiClass containingClass = ((PsiClass)resolved).getContainingClass();
        if (containingClass != null && !((GroovyCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)resolved.getProject()).getCustomSettings(GroovyCodeStyleSettings.class)).INSERT_INNER_CLASS_IMPORTS) {
            return false;
        }
        return resolveResult.getElement() == null || !resolveResult.isAccessible() || !resolveResult.isStaticsOK();
    }
}

