/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.confusing;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GroovyResultOfIncrementOrDecrementUsedInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Potentially confusing code constructs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyResultOfIncrementOrDecrementUsedInspection", "getGroupDisplayName"));
        }
        return "Potentially confusing code constructs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Result of increment or decrement used" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/confusing/GroovyResultOfIncrementOrDecrementUsedInspection", "getDisplayName"));
        }
        return "Result of increment or decrement used";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Result of increment or decrement expression used #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitUnaryExpression(GrUnaryExpression grUnaryExpression) {
            super.visitUnaryExpression(grUnaryExpression);
            IElementType tokenType = grUnaryExpression.getOperationTokenType();
            if (!GroovyTokenTypes.mINC.equals(tokenType) && !GroovyTokenTypes.mDEC.equals(tokenType)) {
                return;
            }
            if (PsiUtil.isExpressionUsed(grUnaryExpression)) {
                this.registerError(grUnaryExpression);
            }
        }
    }
}

